/*  */

alias( simplifySyntactically = simplify::simplifyCondition::simplifySyntactically ):

simplify::simplifyCondition::simplifySyntactically::slot_and := proc( cond : "_and", options )
    local i, j, k, l, ops, o1, o2, i1, i2, v, res, s, donext,
      tt1, tt2, /* types of operands */
      sstr, /* sort order */
      vartypes, /* list of all vars which are implicit declard real/ not real */
      orv, ourv, /* realvars, unrealvars */
      operands, /* list of all operands */
      decide;
    save MAXEFFORT;
begin
  decide := options[ "decide" ];

  cond := simplify::simplifyLogic( cond );
  if type(cond)<>"_and" then return( simplifySyntactically(cond,options) ); end_if;
  if MAXEFFORT<nops(cond) then
    return(cond);
  end_if;

  /* save variables */
  orv := options["realvars"];
  ourv := options["unrealvars"];

  /* sort conditions
  * first all constant expressions, then _ins, then relations, at last _nots ...
  */
  cond := [op(cond)];
  sstr := [ "_in", "_equal", "_unequal", "_less", "_leequal", "_not", "_or" ];
  cond := sort( cond, (a,b)->indets(a) minus Type::ConstantIdents<>{} and ( indets(a) minus Type::ConstantIdents={} or bool(contains( sstr, a )-contains( sstr, b )>0) ) );
  operands := [];

  /* get the list of all implicit real, not real declard identifiers */
  vartypes := map( cond, proc(X)
    begin
        case type(X)
        of "_not" do
          if type(op(X,1))="_in" and type(op(X,[1,1]))=DOM_IDENT and op(X,[1,2])=R_ then
            return( [ {}, {op(X,[1,1])} ] );
          end_if;
          break;
        of "_in" do
          if type(op(X,1))=DOM_IDENT then
            case type(op(X,2))
              of solvelib::BasicSet do
                if op(X,2)=C_ then break; end_if
              of Dom::Interval do
                return( [ {op(X,1)}, {} ] );
            end_case;
          end_if;
          break;
        of "_less" do
        of "_leequal" do
          if type(op(X,1))=DOM_IDENT then return( [ {op(X,1)}, {} ] ); end_if;
          if type(op(X,2))=DOM_IDENT then return( [ {op(X,2)}, {} ] ); end_if;
          break;
        end_case;
        return( [ {}, {} ] );
      end_proc );

    /* be sure no identifiers are real AND not real */
    if _union( op(map( vartypes, op, 1 )) ) intersect _union( op(map( vartypes, op, 2 )) ) <> {} then
      return(FALSE);
    end_if;

  ops := {};
  /* simplify _and-conditions syntactically. this means:
  * a) map simplifySyntactically to all subexpression
  * b) if we have X=(const.) then replace X in all other subexpressions
  * c) check for pares of relations
  */
  i := 1;
  MAXEFFORT := MAXEFFORT/nops(cond);
  while i<=nops(cond) do
    /* update realvars/ unrealvars */
    if i<=nops(vartypes) then
      options["realvars"] := _union( orv, op(map( subsop(vartypes,i=[{},{}]), op, 1 )) );
      options["unrealvars"] := _union( ourv, op(map( subsop(vartypes,i=[{},{}]), op, 2 )) );
    else
      options["realvars"] := _union( orv, op(map( vartypes,op, 1 )) );
      options["unrealvars"] := _union( ourv, op(map( vartypes, op, 2 )) );
    end_if;
    options["decide"] := cond -> options["_decide"](cond, options );
    options["typereal"] := cond -> options["_typereal"](cond, options );
    options["isReal"] := proc(xpr) local O; begin O := options; O["seek"] = TRUE; bool( O["_typereal"](xpr, O )=TRUE ) end_proc;

    /* a) map to subexpression */
    v := simplifySyntactically( op(cond,i),options );
    [cond, operands]:= map([cond, operands],
    // note that in evalAt(diff(y(x), x), {x=0}), we must not substitute x=0 by TRUE!
    misc::maprec,
    (X -> bool(X=v)) = TRUE,
    (X -> not contains({"_and", "_or", "_not"}, type(X))) = id,
    PostMap);
   
    case type(v)
      of "_and" do
        cond := cond.[op(v)];
        v:=null();
        break;
      of "_or" do
        l := 0;
        v:=[op(v)];
        while l<nops(v) do
          l:=l+1;
          donext := FALSE;
          if not contains( {"_equal","_unequal"}, type(op(v,l)) ) then next; end_if;
          res := op(v,[l,1]) - op(v,[l,2]);
          k := FALSE;
          for i2 in freeIndets(res) do
            if k=FALSE then k := Type::Linear( res, [i2] ); i1 := i2; end_if;
          end_for;
          if k=FALSE or decide(k[1]<>0)<>TRUE then next; end_if;
          s := -k[2]/k[1];
          j := 1;
          while j<=nops(operands) and not donext do
            if contains( indets(operands[j] ), i1 ) then
              /* substitute and do a fast decision. if it FALSE remove the condition */
              if traperror( ( res := property::normalGroebner( operands[j], i1=s ) ) )<>0 then res := FALSE; end_if;
              if res=operands[j] then j:=j+1; next; end_if;
              case decide(res)
                of FALSE do
                  if type(v[l])="_unequal" then v:= null(); break; end_if;
                  delete( v[l] ); l:=l-1; donext := TRUE; break;
              end_case;
              if v=null() then break; end_if;
            end_if;
            j := j+1;
          end_while;
          if v=null() then break; end_if;
          j := i+1;
          while j<=nops(cond) and not donext do
            if contains( indets(cond[j] ), i1 ) then
              if traperror( ( res := property::normalGroebner( cond[j], i1=s ) ) )<>0 then res := FALSE; end_if;
              /* substitute and do a fast decision. if it FALSE remove the condition */
              case decide(res)
                of FALSE do
                  if type(v[l])="_unequal" then v:= null(); break; end_if;
                  delete( v[l] ); l:=l-1; donext := TRUE; break;
              end_case;
              if v=null() then break; end_if;
            end_if;
            j := j+1;
          end_while;
          if v=null() then break; end_if;
        end_while;
        if v=null() then break; end_if;
        if nops(v)=0 then return( FALSE ); end_if;
        if nops(v)=1 then
          cond := cond.v; v:=null();
        else
          v := _or( op(v) );
        end_if;
        break;
      of DOM_BOOL do
        if v=FALSE then return(FALSE); end_if;
        if v=TRUE then v:=null(); end_if;
        break;
      /* b) replace X=(const.) in all other subexpressions */
      of "_equal" do
        res := op(v,1) - op(v,2);
        k := FALSE;
        for i2 in freeIndets(res) do
          if k=FALSE then k := Type::Linear( res, [i2] ); i1 := i2; end_if;
        end_for;
        if k=FALSE or decide(k[1]<>0)<>TRUE then break; end_if;
        s := -k[2]/k[1];
        j := 1;
        while j<=nops(operands) do
          if contains( indets(operands[j] ), i1 ) then
            /* substitute and do a fast decision. if it can't be decided put it back into the queue */
            if traperror( ( res := property::normalGroebner( operands[j], i1=s ) ) )<>0 then res := FALSE; end_if;
            if res=operands[j] then j:=j+1; next; end_if;
            case decide(res)
              of UNKNOWN do cond := cond.[res]; break;
              of FALSE do return(FALSE);
            end_case;
            delete( operands[j] );
            j := j-1;
          end_if;
          j := j+1;
        end_while;
        j := i+1;
        while j<=nops(cond) do
          if contains( indets(cond[j] ), i1 ) then
            if traperror( ( res := property::normalGroebner( cond[j], i1=s ) ) )<>0 then res := FALSE; end_if;
            /* substitute and do a fast decision. if it can't be decided let it in the queue */
            case decide(res)
              of UNKNOWN do cond[j] := res; break;
              of FALSE do return(FALSE);
              of TRUE do cond[j] := TRUE; break;
            end_case;
          end_if;
          j := j+1;
        end_while;
        break;
      of "_unequal" do
        res := op(v,1) - op(v,2);
        k := FALSE;
        for i2 in freeIndets(res) do
          if k=FALSE then k := Type::Linear( res, [i2] ); i1 := i2; end_if;
        end_for;
        if k=FALSE or decide(k[1]<>0)<>TRUE then break; end_if;
        s := -k[2]/k[1];
        j := 1;
        while j<=nops(operands) and v<>null() do
          if contains( indets(operands[j] ), i1 ) then
            if traperror( ( res := property::normalGroebner( operands[j], i1=s ) ) )<>0 then res := FALSE; end_if;
            case decide(res)
              of FALSE do v:=null();
            end_case;
          end_if;
          j := j+1;
        end_while;
        j := i+1;
        while j<=nops(cond) and v<>null() do
          if contains( indets(cond[j] ), i1 ) then
            if traperror( ( res := property::normalGroebner( cond[j], i1=s ) ) )<>0 then res := FALSE; end_if;
            case decide(res)
              of FALSE do v:=null();
            end_case;
          end_if;
          j := j+1;
        end_while;
        break;
    end_case;

    /* d) check for paris of relations with
    * (A op B) and (A op B)
    * or
    * (A op B) and (B op A)
    */
    o1 := v;
    case type(v)
      of "_not" do
        if not contains( {"_less", "_leequal", "_equal", "_unequal"}, type( op(v) ) ) then break; end_if;
        o1 := op(v);
      of "_less" do
      of "_leequal" do
      of "_equal" do
      of "_unequal" do
        if ops minus {op(o1)}={} then
          j := 1;
          tt1 := type(o1);
          if type(v)="_not" then tt1 := "not".tt1; end_if;
          while v<>null() and j<=nops(operands) do
            o2 := operands[j];
            if contains( {"_less", "_leequal", "_equal", "_unequal"}, type( o2 ) ) or (type(o2)="_not" and contains( {"_less", "_leequal", "_equal", "_unequal"}, type( op(o2) ) )) then
              if type(o2)="_not" then
                o2 := op(o2);
                tt2 := "not".type(o2);
              else
                tt2 := type(o2);
              end_if;
              /* case 1: (A op B) and (A op B) */
              if op(o1,1)=op(o2,1) and op(o1,2)=op(o2,2) then
                case { tt1, tt2 }
                  of { "not_leequal", "not_less" } do /* not x<y and not x<=y */
                  of { "_unequal", "not_less" } do /* x<>y and not x<y */
                  of { "_unequal", "not_leequal" } do /* x<>y and not x<=y */
                    operands[j] := not op(o1,1)<=op(o1,2);
                    v:=null();
                    break;
                  of { "_less", "_leequal" } do /* x < y and x <= y */
                  of { "_less", "_unequal" } do /* x < y and x <> y */
                  of { "_leequal", "_unequal" } do /* x <= y and x <> y */
                    /* TODO: decide kann weg (tcov=0) */
                    case decide( op(o1,1)<op(o1,2) )
                      of FALSE do return(FALSE);
                      of TRUE do operands[j] := null();
                      of UNKNOWN do operands[j] := op(o1,1)<op(o1,2);
                    end_case;
                    v:=null();
                    next;
                  of { "_leequal", "_equal" } do /* x <= y and x = y */
                    operands[j] := op(o1,1)=op(o1,2);
                    if not simplify::ignoreImplicitR_Property then cond := cond.[ op(o1,1) in R_ ] end_if;
                    v:=null();
                    next;
                  of { "_less", "_equal" } do /* x < y and x = y */
                  of { "_unequal", "_equal" } do /* x <> y and x = y */
                    return( FALSE );
                end_case;
              /* case 2: (A op B) and (B op A) */
              elif op(o1,1)=op(o2,2) and op(o1,2)=op(o2,1) then
                case { tt1, tt2 }
                  of { "not_leequal" } do /* not x<=y and not y<=x */
                    operands[j] := not op(o1,1) in R_ or not op(o1,2) in R_;
                    v:=null();
                    break;
                  of { "not_less" } do /* not x<y and not y<x */
                    operands[j] := op(o1,1)=op(o1,2) or not op(o1,1) in R_ or not op(o1,2) in R_;
                    v:=null();
                    break;
                  of { "_less", "not_less" } do /* x<y and not y<x */
                  of { "_less", "not_leequal" } do /* x<y and not y<=x */
                  of { "_leequal", "not_leequal" } do /* x<=y and not y<=x */
                    if type(v)= "_not" then
                      operands[j] := op(o2,1)<op(o2,2);
                    else
                      operands[j] := op(o1,1)<op(o1,2);
                    end_if;
                    v:=null();
                    break;
                  of { "_unequal", "not_leequal" } do /* x<>y and not y<=x */
                  of { "_unequal", "not_less" } do /* x<>y and not y<x */
                    if type(o1)="_unequal" then
                      operands[j] := not op(o2,1)<=op(o2,2);
                    else
                      operands[j] := not op(o1,1)<=op(o1,2);
                    end_if;
                    v:=null();
                    break;
                  of { "_equal" } do /* x = y and y = x */
                    operands[j] := op(o1,1)=op(o1,2);
                    v:=null();
                    next;
                  of { "_equal", "_leequal" } do /* x = y and y <= x */
                  of { "_leequal" } do /* x <= y and y <= x */
                    operands[j] := op(o1,1)=op(o1,2);
                    if not simplify::ignoreImplicitR_Property then cond := cond.[ op(o1,1) in R_ ] end_if;
                    v:=null();
                    next;
                  of { "_less", "_unequal" } do /* x < y and y <> x */
                  of { "_leequal", "_unequal" } do /* x <= y and y <> x */
                    if type(o1)="_unequal" then
                      operands[j] := op(o2,1)<op(o2,2);
                    else
                      operands[j] := op(o1,1)<op(o1,2);
                    end_if;
                    v:=null();
                    next;
                  of { "_less" } do /* x < y and y < x */
                  of { "_less", "_leequal" } do /* x < y and y <= x */
                  of { "_equal", "_unequal" } do /* x = y and y <> x */
                  of {"_less", "_equal" } do /* x=y and x<y */
                    return( FALSE );
                end_case;
              end_if;
            end_if;
            j:=j+1;
          end_while;
        else
          ops := ops union {op(o1)};
        end_if;
    end_case;

    if v<>null() and contains( operands, v )=0 then
      operands := operands.[v];
    end_if;
    i := i+1;
  end_while;

  /* do we have anything left to check? */
  if nops(operands)=0 then return(TRUE); end_if;

  /* remap simplifyLogic after all terms are in normal form */
  cond :=  _and(  op(operands) );
  cond := simplify::simplifyLogic( cond );

  return( cond );
end_proc:  /* simplifySyntactically::simplifySyntactically_and */
