

/*
   simplify::conjugate(a)

   simplifies products in which a conjugate occurs

   implements the rules

   z*conjugate(z) = abs(z)^2
   z + conjugate(z) = 2*Re(z)

*/
simplify::conjugate:=
proc(a)
  local conj: DOM_LIST, other: DOM_LIST, dummy: DOM_LIST, 
  r, found: DOM_BOOL, 
  i: DOM_INT, j: DOM_INT, ops: DOM_LIST, bas, expo; 
begin
  case type(a)
  of "_mult" do
    [conj, other, dummy]:= split([op(a)], testtype, "conjugate");
    ops:= map(conj, op, 1); // arguments of conjugate
    r:= 1;
    found:= FALSE;
    assert(dummy = []);
    // loop invariant: a = r * op(conj) * op(other)
    for i from 1 to nops(other) do
      if (j:= contains(ops, other[i])) > 0 then
        // conj[j] = conjugate(other[i])
        // replace conj[j] * other[i] by abs(other[i])^2
        r:= r * abs(other[i])^2;
        found:= TRUE;
        delete ops[j], conj[j];
        other[i]:= 1; // we do not want to delete and re-number the operands here
      elif type(other[i]) = "_power" then
        [bas, expo]:= [op(other[i])];
        // we may turn bas^expo*conjugate(bas) into abs(bas)^2 * bas^(expo-1)
        // unless bas is zero and we would create a negative exponent
        if (j:= contains(ops, bas)) > 0 and 
        is(bas <> 0 or not expo in Dom::Interval([0], 1), Goal = TRUE) then
          r:= r * abs(bas)^2;
          found:= TRUE;
          delete ops[j], conj[j];
          other[i]:= bas^(expo-1);
        end_if;
      end_if;
    end_for;  
    if found then
      return(r * op(conj) * op(other))
    else
      break
    end_if;  
  of "_plus" do
    [conj, other, dummy]:= split([op(a)], testtype, "conjugate");
    ops:= map(conj, op, 1); // arguments of conjugate
    r:= 0;
    found:= FALSE;
    assert(dummy = []);
    // loop invariant: a = r + op(conj) + op(other)
    for i from 1 to nops(other) do
      if (j:= contains(ops, other[i])) > 0 then
        // conj[j] = conjugate(other[i])
        // replace conj[j] + other[i] by 2*Re(other[i])
        r:= r + 2*Re(other[i]);
        found:= TRUE;
        delete ops[j], conj[j];
        other[i]:= 0; // we do not want to delete and re-number the operands here
        // we might want do create another elif-branch here to make conjugate(z) + 2*z into z + 2*Re(z) ?!
      end_if;
    end_for;  
    if found then
      return(r + op(conj) + op(other))
    else
      break
    end_if;  
    
  end_case;
  a  
end_proc:
  
  
  