//    

/*--
	simplify/exp -- the function attribut "exp" for simplify

	simplifies expressions containing exponentials
        with algebraic dependencies, for example exp(x)
        and exp(x/2), by substituting with new variables,
        calling simplify, and substituting back.
--*/

simplify::exp:=
proc(a, options = simplify::defaultOptions)
  local e,i,s, b, f, q, minpolys, X, eq, opt;
begin
  assert(testtype(a, Type::Arithmetical));
   
  // do *not* rewrite powers by exp!
  // a:= rewrite(a, exp);
  
  // the following would also rewrite too much:
  // a:= misc::maprec(a, {"sin", "cos", "tan", "sinh", "cosh", "tanh"} = (X -> rewrite(X, exp)));

  // first heuristic: combine
  opt:= combine::defaultOptions;
  opt[IgnoreAnalyticConstraints]:= options[IgnoreAnalyticConstraints];
  a:= combine::exp(a, opt);
 

  opt:= rationalize::defaultOptions;
  opt[ReplaceTypes]:= {"int"};

  [b, s]:= rationalize::replaceTypes(a, opt);  

  b:= misc::maprec(b, {"exp"} = (X -> if type(op(X, 1)) = "_plus" then _mult(exp(op(X, [1, i])) $i=1..nops(op(X, 1))) else X end));  
  
  b:= normal(b, Expand = TRUE);
  b:= subs(b, s);

  if length(b) < length(a) then
    a:= b
  end_if;
    
  
  // first rationalize a
  [e, s, minpolys]:= [rationalize(a, FindRelations = ["exp"], MinimalPolynomials)];
  
 
  
  // often harmless recursive call, where e is a rational expression
  // but beware, there may be large exponents?!
  // e:= simplify(e, options);
  
  minpolys:= select(minpolys, X -> simplify::expandComplexity(X) < 1000);   

  if nops(minpolys) > 0 then 
     minpolys:= map(minpolys, numer);   
     e:= property::normalGroebner(e, [op(minpolys)]);
  end_if;  
  
  // heuristic to recognize sinh and cosh 
  // this heuristic is very weak and does not even recognize sinh(x)^2, cosh(x)^2
  for i from 1 to nops(s) do 
    eq:= op(s, i);
    if type((b:= op(eq, 2))) = "exp" then 
  	   // if b= exp(T), then 
       // (b^2+1)/2/b = cosh(T) and
       // (b^2-1)/2/b = sinh(T)
       X:= op(eq, 1);
       if (f:= poly(2*e*X, [X])) <> FAIL then 
         // f represents 2*exp(T) * e
         q:= divide(f, poly(X^2 + 1, [X]), Exact);
         if q <> FAIL then
           // q represents f/(exp(T)^2 + 1) = 2*exp(T)/(exp(T)^2 + 1) * e = e/cosh(T)
           e:= expr(q)*cosh(op(b, 1))
         elif  (q:= divide(f, poly(X^2 - 1, [X]), Exact)) <> FAIL then
           // w represents e/sinh(T)
           e:= expr(q)*sinh(op(b, 1))
         end_if;  
       end_if;  
    end_if;
  end_for;   
    
  subs(e, s, EvalChanges);
  
end_proc:

// end of file 
