// _plus::simplify - simplification rules for sums

_plus::simplify:=
proc(e)
  local t;

begin
  
 
  
  if MAXEFFORT < 500 or MAXEFFORT < property::complexity(e) then
    return(e)
  end_if;

  if not testtype(e, Type::Arithmetical) then
    return(e)
  end_if;

  if hastype(e, {"sinh", "cosh", "tanh", "coth"}) then
    t:= rewrite(e, exp);
    if length(t) < length(e) then
      e:= t
    end_if
  end_if;
  

  t:= simplify::fractionalPowers(e);  
  if length(t) < length(e) then
      e:= t;
      if type(e) <> "_plus" then
         return(e)
      end_if;
  end_if;
 


    
  // take care of expansions to f(I) such as exp(I*x)+I!
  if simplify::expandComplexity(e) < 500 and length((t:= maprat( e, X-> expand(X, MaxExponent = 64)))) < length(e) 
  then
    e:= t
  end_if;
  
 
  if traperror((t:= expr(polylib::sqrfree(e))), MaxSteps = 30) = 0 and  
    Simplify::complexity(t) < Simplify::complexity(e) + 1000 then
    e:= map(t, normal, Recursive = FALSE)
  end_if;  
  e
 


 
end_proc: