arccosh::simplify:=
proc(a: "arccosh", options = simplify::defaultOptions: DOM_TABLE)
  local x;
begin
  x:= op(a, 1);  // a = arccosh(x)

  if type(x) = "cosh" then // x = cosh(y) 
    x:= op(x, 1);
    if options[IgnoreAnalyticConstraints] or
       is((Im(x)> -PI/2 and Im(x)< PI/2) or
          (Im(x)> -PI/2 and Im(x)<=PI/2 and Re(x)>= 0) or
          (Im(x)>=-PI/2 and Im(x)< PI/2 and Re(x)<= 0) or
	  (Re(x) = 0 and -PI<=Im(x) and Im(x)<=PI)
         ) = TRUE then
      return(sqrt(x^2))
    end_if;
  elif type(-x) = "cosh" then // x = -cosh(y) = cosh(I*PI +/- y) 
    x:= op(-x, 1);
    if options[IgnoreAnalyticConstraints] or
       is( Im(x) = 0 or
          (Im(x)>=-PI/2 and Im(x)<=0    and Re(x)<= 0) or
          (Im(x)>= 0    and Im(x)<=PI/2 and Re(x)>= 0) 
         ) = TRUE then
       return(I*PI - sqrt(x^2));
    end_if;
    if is((Im(x)> -3*PI/2 and Im(x)< -PI/2) or
          (Im(x)> -3*PI/2 and Im(x)<=-PI/2 and Re(x)>=0) or
          (Im(x)>=-3*PI/2 and Im(x)< -PI/2 and Re(x)<=0) or
          (Re(x) = 0 and -2*PI<=Im(x) and Im(x)<=0)
       ) = TRUE then
      return(sqrt((I*PI + x)^2));
    end_if;
    if is((Im(x)< 3*PI/2 and Im(x)> PI/2) or
          (Im(x)< 3*PI/2 and Im(x)>=PI/2 and Re(x)<= 0) or
          (Im(x)<=3*PI/2 and Im(x)> PI/2 and Re(x)>= 0) or
          (Re(x) = 0 and 2*PI>=Im(x) and Im(x)>=0)
       ) = TRUE then
      return(sqrt((I*PI - x)^2));
    end_if;
  elif type(x/I) = "sinh" then // x = I*sinh(y) = cosh(I*PI/2 + y)
    x:= op(x/I, 1);
    if options[IgnoreAnalyticConstraints] or
       is((Im(x)> -PI and Im(x)< 0) or
          (Im(x)> -PI and Im(x)<=0 and Re(x) >= 0) or
          (Im(x)>=-PI and Im(x)< 0 and Re(x) <= 0) or
	  (Re(x) = 0  and -3/2*PI<=Im(x) and Im(x)<=PI/2)
         ) = TRUE then
      return(sqrt((I*PI/2 + x)^2));
    end_if;
  elif type(-x/I) = "sinh" then // x = -I*sinh(y) = cosh(I*PI/2 - y)
    x:= op(-x/I, 1);
    if options[IgnoreAnalyticConstraints] or
       is((Im(x)< PI and Im(x)> 0) or
          (Im(x)< PI and Im(x)>=0 and Re(x)<= 0) or
          (Im(x)<=PI and Im(x)> 0 and Re(x)>= 0) or
	  (Re(x) = 0 and 3/2*PI>=Im(x) and Im(x)>=-PI/2)
         ) = TRUE then
      return(sqrt((I*PI/2 - x)^2));
    end_if;
  elif type(x) = "cos" then // x = cos(y) = cosh(+/-I*y)
    x:= op(x, 1);
    // The following simplification is valid for Im(x) = 0 and 0 <= Re(x) <= PI
    if options[IgnoreAnalyticConstraints] or
       is((Re(x)> -PI/2 and Re(x)< PI/2) or
          (Re(x)> -PI/2 and Re(x)<=PI/2 and Im(x)<= 0) or
          (Re(x)>=-PI/2 and Re(x)< PI/2 and Im(x)>= 0) or
          (Im(x) = 0 and -PI<=Re(x) and Re(x)<=PI)
         ) = TRUE then
      return(sqrt(-x^2))
    end_if;
  elif type(-x) = "cos" then // -cos(y) = cosh(I*PI +/- I*y)
    x:= op(-x, 1);
    if is((Re(x)> -3*PI/2 and Re(x)< -PI/2) or
          (Re(x)> -3*PI/2 and Re(x)<=-PI/2 and Im(x)<= 0) or
          (Re(x)>=-3*PI/2 and Re(x)< -PI/2 and Im(x)>= 0) or
	  (Im(x) = 0 and -2*PI<=Re(x) and Re(x)<=0)
         ) = TRUE then
      return(sqrt(-(PI + x)^2))
    end_if;
    if options[IgnoreAnalyticConstraints] or
       is((Re(x)< 3*PI/2 and Re(x)> PI/2) or
          (Re(x)< 3*PI/2 and Re(x)>=PI/2 and Im(x)>= 0) or
          (Re(x)<=3*PI/2 and Re(x)> PI/2 and Im(x)<= 0) or
	  (Im(x) = 0 and 2*PI>=Re(x) and Re(x)>=0)
         ) = TRUE then
      return(sqrt(-(PI - x)^2))
    end_if;
  elif type(x) = "sin" then // x = sin(y) = cosh(I*PI/2-I*y)
    x:= op(x, 1);
    if options[IgnoreAnalyticConstraints] or
       is((Re(x)< PI and Re(x)> 0) or
          (Re(x)< PI and Re(x)>=0 and Im(x) >= 0) or
          (Re(x)<=PI and Re(x)> 0 and Im(x) <= 0) or
	  (Im(x) = 0 and 3/2*PI>=Re(x) and Re(x)>=-PI/2)
         ) = TRUE then
      return(sqrt(-(PI/2 - x)^2));
    end_if;
  elif type(-x) = "sin" then // x = -sin(y) = cosh(I*PI/2+I*y)
    x:= op(-x, 1);
    if options[IgnoreAnalyticConstraints] or
       is((Re(x)> -PI and Re(x)< 0) or
          (Re(x)> -PI and Re(x)<=0 and Im(x) <= 0) or
          (Re(x)>=-PI and Re(x)< 0 and Im(x) >= 0) or
	  (Im(x) = 0 and -3/2*PI<=Re(x) and Re(x)<=PI/2)
         ) = TRUE then
      return(sqrt(-(PI/2 + x)^2));
    end_if;
  end_if;
  // default
  return(a);
end_proc:
