
arccoth::simplify:=
proc(a: "arccoth", options = simplify::defaultOptions: DOM_TABLE)
  local /*reciprocalIsSimpler: DOM_PROC,*/ x, mtch;
begin

  x:= op(a, 1);  // a = arccoth(x)

  if type(x/I) = "cot" then // x = I*cot(y) = coth(-y*I)
    x:= op(x/I, 1);
    if options[IgnoreAnalyticConstraints] or
       is( (              Re(x)> -PI/2 and Re(x)< PI/2) or
           (Im(x)>= 0 and Re(x)> -PI/2 and Re(x)<=PI/2) or
           (Im(x)<= 0 and Re(x)>=-PI/2 and Re(x)< PI/2) or
           (Im(x) = 0 and Re(x)>=-PI/2 and Re(x)<=PI/2)
	 ) = TRUE then
         return(-I*x)
    end_if;
  elif type(-x/I) = "cot" then // -I*cot(y) = coth(y*I)
    x:= op(-x/I, 1);
    if options[IgnoreAnalyticConstraints] or
       is( (              Re(x)> -PI/2 and Re(x)< PI/2) or
           (Im(x)>= 0 and Re(x)> -PI/2 and Re(x)<=PI/2) or
           (Im(x)<= 0 and Re(x)>=-PI/2 and Re(x)< PI/2) or
           (Im(x) = 0 and Re(x)>=-PI/2 and Re(x)<=PI/2)
	 ) = TRUE then
         return(x*I)
    end_if;
  elif type(x) = "coth" then // x = coth(y) 
    x:= op(x, 1);
    if options[IgnoreAnalyticConstraints] or
       is( (              Im(x)> -PI/2 and Im(x)< PI/2) or
           (Re(x)>= 0 and Im(x)>=-PI/2 and Im(x)< PI/2) or
           (Re(x)<= 0 and Im(x)> -PI/2 and Im(x)<=PI/2) or
           (Re(x) = 0 and Im(x)>=-PI/2 and Im(x)<=PI/2)
	 ) = TRUE then
         return(x)
    end_if;
  elif type(-x) = "coth" then // x = -coth(y) = coth(-y)
    x:= op(-x, 1);
    if options[IgnoreAnalyticConstraints] or
       is( (              Im(x)> -PI/2 and Im(x)< PI/2) or
           (Re(x)>= 0 and Im(x)>=-PI/2 and Im(x)< PI/2) or
           (Re(x)<= 0 and Im(x)> -PI/2 and Im(x)<=PI/2) or
           (Re(x) = 0 and Im(x)>=-PI/2 and Im(x)<=PI/2)
	 ) = TRUE then
         return(-x)
    end_if;
  elif type(1/x) = "tanh" then //  x = 1/tanh(y) = coth(y)
    x:= op(1/x, 1);
    if options[IgnoreAnalyticConstraints] or
       is( (              Im(x)> -PI/2 and Im(x)< PI/2) or
           (Re(x)>= 0 and Im(x)>=-PI/2 and Im(x)< PI/2) or
           (Re(x)<= 0 and Im(x)> -PI/2 and Im(x)<=PI/2) or
           (Re(x) = 0 and Im(x)>=-PI/2 and Im(x)<=PI/2)
	 ) = TRUE then
         return(x)
    end_if
  elif type(-1/x) = "tanh"  then // x =  -1/tanh(y) = coth(-y)
    x:= op(-1/x, 1);
    if options[IgnoreAnalyticConstraints] or
       is( (              Im(x)> -PI/2 and Im(x)< PI/2) or
           (Re(x)>= 0 and Im(x)>=-PI/2 and Im(x)< PI/2) or
           (Re(x)<= 0 and Im(x)> -PI/2 and Im(x)<=PI/2) or
           (Re(x) = 0 and Im(x)>=-PI/2 and Im(x)<=PI/2)
	 ) = TRUE then
         return(-x)
    end_if
  elif type(I/x) = "tan" then // x = I/tan(y) = coth(-y*I)
    x:= op(I/x, 1);
    if options[IgnoreAnalyticConstraints] or
       is( (              Re(x)> -PI/2 and Re(x)< PI/2) or
           (Im(x)>= 0 and Re(x)> -PI/2 and Re(x)<=PI/2) or
           (Im(x)<= 0 and Re(x)>=-PI/2 and Re(x)< PI/2) or
           (Im(x) = 0 and Re(x)>=-PI/2 and Re(x)<=PI/2)
	 ) = TRUE then
         return(-x*I)
    end_if
  elif type(-I/x) = "tan" then // x = -I/tan(y) = coth(y*I)
    x:= op(-I/x, 1);
    if options[IgnoreAnalyticConstraints] or
       is( (              Re(x)> -PI/2 and Re(x)< PI/2) or
           (Im(x)>= 0 and Re(x)> -PI/2 and Re(x)<=PI/2) or
           (Im(x)<= 0 and Re(x)>=-PI/2 and Re(x)< PI/2) or
           (Im(x) = 0 and Re(x)>=-PI/2 and Re(x)<=PI/2)
	 ) = TRUE then
         return(x*I)
    end_if
  end_if:

  //====================================================
  // We still wish to implement simplifications based on
  //
  //  arccoth(z) - arccoth(1/z) = PI/2*signIm(I*z) * s(z)
  //
  // where s(z) = 1 for nearly all z in C_ apart from
  // the intervals z/I in (-1, 0) union (0, 1) along the
  // real line, where s(z) = -1.
  //====================================================
  // Start over again
  x:= op(a, 1);

  if (mtch:= match(x, sinh(`#X`)/cosh(`#X`))) <> FAIL then
     return(simplify(arccoth(coth(op(mtch, [1, 2]))), options))
  end_if;

/*
  //==========================================
  reciprocalIsSimpler:= proc(x)
    local y;
  begin
    case domtype(x)
      of DOM_INT do return(FALSE);
      of DOM_RAT do return(bool(abs(x) < 1));
    end_case;
    y:= 1/x;
    case specfunc::sign(length(x) - length(y))
      of  1 do return(TRUE);
      of -1 do return(FALSE);
      of 0 do return(sysorder(y, x));
    end_case;
  end_proc;
  //==========================================

  case sign(Re(x))
    of 1 do
    of 0 do
      if reciprocalIsSimpler(x) then
        return(-arccoth(1/x) + 1/2*PI)
      else
        break
      end_if;
    of -1 do
      if reciprocalIsSimpler(1/x, x) then
         return(-arccoth(1/x) - 1/2*PI)
      else
        break
      end_if
  end_case;
*/
  
  return(a)
end_proc:
