
arcsin::simplify:=
proc(a: "arcsin", options = simplify::defaultOptions: DOM_TABLE)
  local x;
begin
  x:= op(a, 1);  // a = arcsin(x)
  if type(x) = "sin" then
    x:= op(x, 1);
    if options[IgnoreAnalyticConstraints] or
       is((Re(x) > -PI/2 and Re(x) < PI/2) or
          (Re(x) >=-PI/2 and Re(x) < PI/2 and Im(x) >=0) or
          (Re(x) > -PI/2 and Re(x) <=PI/2 and Im(x) <=0) or
          (Re(x) >=-PI/2 and Re(x) <=PI/2 and Im(x) = 0)
         ) = TRUE then
      return(x)
    end_if;
  elif type(-x) = "sin" then // -sin(y) = sin(-y)
    x:= op(-x, 1);
    if options[IgnoreAnalyticConstraints] or
       is((Re(x) > -PI/2 and Re(x) < PI/2) or
          (Re(x) >=-PI/2 and Re(x) < PI/2 and Im(x) >=0) or
          (Re(x) > -PI/2 and Re(x) <=PI/2 and Im(x) <=0) or
          (Re(x) >=-PI/2 and Re(x) <=PI/2 and Im(x) = 0)
         ) = TRUE then
      return(-x)
    end_if;
  elif type(x/I) = "sinh" then // x = I*sinh(y) = sin(y*I)
    x:= op(x/I, 1);
    if options[IgnoreAnalyticConstraints] or
       is((Im(x) >-PI/2 and Im(x) < PI/2) or
          (Im(x) >-PI/2 and Im(x) <=PI/2 and Re(x) >= 0) or
          (Im(x)>=-PI/2 and Im(x) < PI/2 and Re(x) <= 0) or
          (Im(x)>=-PI/2 and Im(x) <=PI/2 and Re(x) =  0)
         ) = TRUE then
      return(x*I)
    end_if;
  elif type(-x/I) = "sinh" then // x = -I*sinh(y) = sin(-y*I)
    x:= op(-x/I, 1);
    if options[IgnoreAnalyticConstraints] or
       is((Im(x) >-PI/2 and Im(x) < PI/2) or
          (Im(x) >-PI/2 and Im(x) <=PI/2 and Re(x) >= 0) or
          (Im(x)>=-PI/2 and Im(x) < PI/2 and Re(x) <= 0) or
          (Im(x)>=-PI/2 and Im(x) <=PI/2 and Re(x)  = 0)
         ) = TRUE then
      return(-x*I)
    end_if;
  elif type(x) = "cos" then // cos(y) = sin(PI/2 - y)
    // arcsin(cos(x)) = PI/2 - arccos(cos(x))
    x:= op(x, 1);
    if options[IgnoreAnalyticConstraints] or
       is((Re(x) > 0 and Re(x)< PI) or
          (Re(x) >=0 and Re(x)< PI and Im(x) >=0) or
          (Re(x) > 0 and Re(x)<=PI and Im(x) <=0) or
          (Re(x) >=0 and Re(x)<=PI and Im(x)  =0) 
         ) = TRUE then
      return(PI/2 - x)
    end_if
  elif type(-x) = "cos" then // -cos(y) = sin(-PI/2 + y)
    x:= op(-x, 1);
    if options[IgnoreAnalyticConstraints] or
       is((Re(x) > 0 and Re(x) < PI) or
          (Re(x)>= 0 and Re(x) < PI and Im(x) >=0) or
          (Re(x) > 0 and Re(x)<= PI and Im(x) <=0) or
          (Re(x) >=0 and Re(x)<= PI and Im(x)  =0) 
         ) = TRUE then
      return(-PI/2 + x)
    end_if
  elif type(x) = "cosh" then // x = cosh(y) = sin(PI/2 - y*I) 
    x:= op(x, 1);
    if options[IgnoreAnalyticConstraints] or
       is((Im(x) >-PI and Im(x) < 0) or
          (Im(x) >-PI and Im(x)<= 0 and Re(x) >= 0) or
          (Im(x)>=-PI and Im(x) < 0 and Re(x) <= 0) or
          (Im(x)>=-PI and Im(x) <=0 and Re(x)  = 0)
         ) = TRUE then
      return(PI/2 - x*I)
    end_if;
  elif type(-x) = "cosh" then // x = -cosh(y) = sin(-PI/2 + y*I) 
    x:= op(-x, 1);
    if options[IgnoreAnalyticConstraints] or
       is((Im(x) >-PI and Im(x) < 0) or
          (Im(x) >-PI and Im(x)<= 0 and Re(x) >= 0) or
          (Im(x)>=-PI and Im(x) < 0 and Re(x) <= 0) or
          (Im(x)>=-PI and Im(x) <=0 and Re(x)  = 0)
         ) = TRUE then
      return(-PI/2 + x*I)
    end_if;
  end_if;
  // default
  a
end_proc:
