/*
simplify::fractionalPowers(e)

- reduces all irrational subexpressions of e modulo their minimal polynomials
- applies the rule 1/(a+b*sqrt(x)) = (a-b*sqrt(x)) / (a^2 - b^2*x)

*/

simplify::fractionalPowers:=
proc(e)
  local r, l, i, f, X, g, a, b, c, d, nc, inds, numerators,
  tryDivide: DOM_PROC,
  zerotest: DOM_PROC;
begin
  // uses minimal polynomials r[3] from outer procedure
  tryDivide:=
  proc(f, S: DOM_SET) 
    local g, h, i, indf, indg, ind;
  begin
    indf:= indets(f, PolyExpr);
    for i from 1 to nops(S) do 
      g:= op(S, i);
      if length(g) > 20 then
        next
      end_if;  
      indg:= indets(g, PolyExpr);
      ind:= [op(indf intersect indg)];
      if ind = [] or traperror((h:= expr(divide(poly(f, ind), poly(g, ind), DegInvLexOrder, Rem))), MaxSteps = 1) <> 0 then 
        next
      end_if;  
    	if h <> FAIL then
       if length(h) < 2*length(f) then
         h:= normal(h);
         if length(h) < length(f) then
    	     f:= h
         end_if
       end_if
      end_if
    end_for;
    f
  end_proc;
  
  // local method zerotest: checks whether a might be constantly zero
  zerotest:=
  proc(a)
  begin
    // the following simple version led to problems:
    // bool(indets(a) = {} and is(a=0, Goal = TRUE))
    bool(testeq(a, 0, Steps = 0) <> FALSE) 
  end_proc;
  
  r:= rationalize(e, FindRelations = ["_power"], MinimalPolynomials);
  
  if op(r, 3) = {} then
    return(e)
  end_if;  
  
  numerators:= map(r[3], numer);

  if traperror((l:= normal(op(r, 1), Recursive = FALSE, List)), MaxSteps = 10) <> 0 then
    return(e)
  end_if;
  if length(l[1]) > 10*length(e) or length(l[2]) > 10*length(e) then 
    return(e)
  end_if;  
    
  l:= map(l, tryDivide, numerators);
  
  for i from 1 to nops(r[3]) do 
    if simplify::expandComplexity((f:= op(r, [3, i]))) > 200 then
      next 
    end_if;  
    inds:= indets(f);
    for X in inds do 
      f:= poly(op(r, [3, i]), [X]);
      if f <> FAIL and
        (d:= degree(f)) mod 2 = 0 and d>0 then
        if type(l[2]) = "_power" and op(l[2], 2) > 100 then
          next
        end_if;
        g:= poly(l[2], [X]);
        if g = FAIL then
          next
        end_if;  
        g:= divide(g, f, Rem);
        c:= expr(g);
        if length(c) > length(l[2]) + 100 then
          next
        else
          l[2]:= c;  
        end_if;   
          
        if degree(g) <> d/2 or nterms(g) <> 2 or iszero(coeff(g, 0)) then 
          next
        end_if;  
        b:= coeff(g, 0);
        a:= lcoeff(g);
      
               
        // we may multiply both numerator and denominator by a*X^(d/2)-b
        c:= expr(divide(poly(a^2*X^d - b^2, [X]), f, Rem));
        assert(c <> FAIL);
        if length(c) > 2*length(l[2]) + 50 then
          next
        end_if;  

        // quick check that our new denominator a^2*X^d-b^2 does not represent zero
        if zerotest(subs(c, [op(op(r, 2))])) then
          next
        end_if;
       
        // we now know that l[2] = a*X^(d/2) + b
        // thus 
        // l[1]/l[2] = (a*X^(d/2)-b)*l[1] / (a^2*X^d - b^2)
        //           = (a*X^(d/2)-b)*l[1] / c
        l[1]:= l[1]*a*X^(d/2)-l[1]*b;
        nc:= normal(c);
        if length(nc) < 2*length(c) + 50 then 
          l[2]:= nc
        else 
          l[2]:= c
        end_if;  
        l[1]:= tryDivide(l[1], numerators);
        break
      end_if  
    end_for;  
  end_for;  
  
  subs(l[1]/l[2], [op(op(r, 2))], EvalChanges)
end_proc:	
