/* The simplify attribute heaviside

   Rules:
   1) heaviside(-x) = 1 - heaviside(x) 
*/

heaviside := slot(heaviside, "simplify", proc(a)
   name heaviside::simplify;
   local s, x;
begin
   // recursively simplify the argument
   x:= op(a, 1): // a = heaviside(x)
   x := simplify(x);
   [s, x] := stdlib::normalizesign(x):
   if s = -1 then
      return(1 - heaviside(x));
   end_if;
   return(heaviside(x));
end_proc):
