simplify::simplifySets_union :=
proc( X : "_union" )
  local originaloperands, operands, s, a, maxeffort;
  save MAXEFFORT;
begin
  maxeffort:= MAXEFFORT/2;

  /* first simplify all operands */
  originaloperands:= [op(X)];
  MAXEFFORT:= maxeffort/nops(originaloperands);
  operands := map(originaloperands, simplify::simplifySets);

  MAXEFFORT:= maxeffort;
  /* collect all C_ minus S_i and rewrite to C_ minus (_intersect S_i) */
  s := split(operands, X->bool(type(X)="_minus" and op(X,1)=C_));
  if nops(s[1])>1 then
    a := simplify::simplifySets(_intersect(op(map(s[1], op, 2))));
    /* if a is an intersect-object we distribute the terms since a generic
     * C_ minus _intersect(...) can be expensive */
    if type(a)="_intersect" then
      operands := s[2].[map(op(a), X->C_ minus X)];
    else
      operands := s[2].[C_ minus a];
    end_if;
  end_if;

  /* if something changed, then reevaluate */
  if [op(X)] <> operands then
    X := _union( op( operands ) )
  end_if;

  X
end_proc:

simplify::simplifySets_intersect :=
proc( X : "_intersect" )
  local originaloperands, operands, s, a, maxeffort;
    save MAXEFFORT;
begin
  maxeffort:= MAXEFFORT/2;

  /* first simplify all operands */
  originaloperands:= [op(X)];
  MAXEFFORT:= maxeffort/nops(originaloperands);
  operands:= map(originaloperands, simplify::simplifySets);

  MAXEFFORT:= maxeffort;
  /* collect all C_ minus S_i and rewrite to C_ minus (_union S_i) */
  s := split(operands, X->bool(type(X)="_minus" and op(X,1)=C_));
  if nops(s[1])>1 then
    a := simplify::simplifySets(_union(op(map(s[1], op, 2))));
    /* if a is an union-object we distribute the terms since a generic
     * C_ minus _union(...) can be expensive */
    if type(a)="_union" then
      operands := s[2].[map(op(a), X->C_ minus X)];
    else
      operands := s[2].[C_ minus a];
    end_if;
  end_if;

  if originaloperands <> operands then
    X := _intersect(op(operands));
    if not testtype(X, "_intersect") then
      return(simplify::simplifySets(X));
    end_if;
  end_if;

  X;
end_proc:

simplify::simplifySets_minus := proc( X : "_minus" )
begin
  /* rewrite "X minus Y minus Z"
   * to X minus (Y union Z) */
  if type( op(X,1) )="_minus" then
    return( simplify::simplifySets( op(X,[1,1]) minus _union( op(X,[1,2]), op(X,2) ) ) );
  end_if;

  /* simplify all subsets */
  X := map(X, simplify::simplifySets);
  if not testtype( X, "_minus" ) then return( simplify::simplifySets(X) ); end_if;

  return(X);
end_proc:

simplify::simplifySets := proc( X )
begin
  case type(X)
    of "_minus" do
      X := simplify::simplifySets_minus( X );
      break;
    of "_intersect" do
      X := simplify::simplifySets_intersect( X );
      break;
    of "_union" do
      X := simplify::simplifySets_union( X );
      break;
  end_case;
  X;
end_proc:
