//    

// kg, 13/01/95 

/*++
alias -- define alias name

alias(abbr=expr,...)

abbr - identifier or function call where the operands must be identifiers
expr - expression

An alias is an expression which is changed by the parser into another
one before evaluating the parsed expression. An alias may be defined
either for identifiers or for function calls:

- With an alias of the form alias(a=b) every a parsed is changed into b.

- With an alias of the form alias(f(x...)=z) every call f(a...) parsed is 
  replaced by subs(z, [x=a...]), ie. f(a...) is replaced by z, whereby the
  'formal parameters' x... of f are replaced by the 'actual parameters' a...

alias doesn't evaluate its arguments.
++*/

alias:=
proc()
  local _0_arg, _0_at, arg2, global, Args, i;
  option hold, noDebug;
begin
  global := null();

  Args := [args()];
  if  (i := contains(Args, Global)) <> 0 then
    global := Global;
    Args[i]:= null();
  end_if;
  
  if testargs() and nops(Args) > 0 then
    for _0_arg in Args do
      if type(_0_arg) <> "_equal" and _0_arg <> Global then
        error("equation expected as ".output::ordinal(contains([args()], _0_arg))." argument")
      end_if;
      if domtype(op(_0_arg, 1)) <> DOM_IDENT then
        if domtype(op(_0_arg, 1)) = DOM_EXPR then
          if nops(op(_0_arg, 1)) <> 0 then
            if {map(op(op(_0_arg, 1)), domtype)} <> {DOM_IDENT} then
              error("illegal parameter(s)")
            end_if
          end_if;
          if type(op(_0_arg, 2)) = "_exprseq" then
            error("illegal alias value")
          end_if
        else
          error("illegal alias name")
        end_if;
      end_if
    end_for
  end_if;

  _0_at:= _parser_config(global);
  
  if nops(Args) = 0 then
    if _0_at = null() or {_0_at[1],_0_at[3]} = {table()} then
      print(NoNL, "No alias defined\n");
      return(null());
    end_if;
    // print alias entries
    output::tableForm(table(op(_0_at[1]),
                            op(map([op(_0_at[3])],
                                   proc(X)
                                     local i;
                                   begin
                                     op(X, 1)(op(op(i, [2, 2]))) = op(i, [2,1]) $ i in op(X,2);
                                   end)))):
    return()
  end_if;

  if _0_at = null() then
    _0_at:= [ table(), table(), table(), [] ];
  end_if;
   
    /* create tables for alias entries
    
       - _0_at[1][a] is the alias value of identifier a.
       - _0_at[2][v] is the identifier associated to value v, needed
            to unalias a (when unalias(a) is called a is replaced by v before
            evaluation, so one must use v to get back a again).
       - _0_at[3][a] is the alias value of operator a, consisting of
            the associated expression and the formal parameters.
    */

    // insert new alias 
    for _0_arg in Args do
      case domtype(_0_arg)
        of DOM_EXPR do
          arg2 := op(_0_arg, 2);
          case domtype(op(_0_arg, 1))
            of DOM_IDENT do
              if contains(_0_at[2], arg2) then
                error("alias '"._0_at[2][arg2]."' for right hand side already exists");
              end_if;
              _0_at[1][op(_0_arg, 1)]:= arg2;
              _0_at[2][arg2]:= op(_0_arg, 1);
              break;
              
            of DOM_EXPR do
              _0_at[3][op(op(_0_arg, 1), 0)][nops(op(_0_arg, 1))]:=
              [arg2, [op(op(_0_arg, 1))]];
              break;
            otherwise error("illegal alias name")
          end_case;
          break;
        otherwise error("illegal argument") ;
      end_case;
    end_for;
  _parser_config(global, _0_at);
  null()
end_proc:

// end of file 
