//   


/*
assert(condition)

check that condition is TRUE, stop with an error otherwise

if not in debug mode (testargs()=TRUE) , do nothing


*/



assert:=
proc(condition)
  option hold;
  option noDebug;
  local increase_context_level, s, i;
begin
  if testargs() then
    if args(0) <> 1 then
      error("Wrong number of arguments")
    end_if;
    if bool(context(condition)) = TRUE then
      userinfo(100, "Checked assertion " . expr2text(context(condition))
                    . "; ok [" .
                    expr2text(context(hold(procname))) . "]")
    else
      // the following piece of code makes all DOM_VARs in condition
      // be output with their real names
      // this highly probably yields nonsense if condition contains
      // "hold", "context", or similar functions

      // increase context level of all DOM_VAR's in condition by 1,
      // i.e., DOM_VAR(0,2) -> DOM_VAR(1,2), DOM_VAR(1,2) -> DOM_VAR(2,2) etc.
      // this is necessary for some mysterious reason
      increase_context_level := proc(e) begin
        if domtype(e) = DOM_VAR then
          subsop(e, 1 = op(e, 1) + 1, Unsimplified)
        elif domtype(e) in {DOM_COMPLEX, DOM_RAT, DOM_INT, DOM_FLOAT, DOM_INTERVAL} then
          e
        elif nops(e) = 0 then
          e
        elif nops(e) = 1 and e = op(e) then
          e
        elif testtype(e, DOM_SET) then
          {op(subsop([op(e)], i = increase_context_level(op(e, i)) $ i = 1..nops(e),
                     Unsimplified))}
        elif domtype(e) = DOM_EXPR then
          subsop(e, i = increase_context_level(op(e, i)) $ i = 0..nops(e),
                 Unsimplified)          
        else
          subsop(e, i = increase_context_level(op(e, i)) $ i = 1..nops(e),
                 Unsimplified)
        end_if
      end_proc:
      s := increase_context_level(condition);

      // strange, but it works ...
      s := context(hold(expr2text)(hold(hold)(s)));
      
      if Pref::typeCheck() = hold(AlwaysWithWarning) then
        context(hold(warning)("Assertion ".s." failed"))
      end_if;

      // the "context" ensures that "error" outputs the name
      // of the calling procedure, and not "[assert]"
      context(hold(error)("Assertion ".s." failed"))
    end_if;
  end_if;

  TRUE
end_proc:
