/*++
   assign.mu

   assign -- perform assignments given as equations 

   assign( egns )
   assign( eqns, subset )

   egns   - a list, set or table of equations 'egn'
   eqn    - equation x=e with x evaluates to a free variable
   subset - set of variables

   For every equation  x=e  of 'eqns' the assignment x:=e is made.  If a
   'subset'  is specified,  an assignment x:=e  is made only  if x is an
   element of 'subset'.  Note that e is any valid expression,  expect an 
   expression sequence containing more than one element. If x is already 
   assigned the identifier z then assign({x=7}) would assign z the value
   7. If x does not evaluates to a free identifier,an error occures. The
   function returns its first argument.

   This function can be applied to a set of equations returned by 'solve'
   when it is desired to assign the solution values to their variables.

   Examples:

   >> solve({a+b=42,2*a+b=55}, {a,b});

                      {[a = 13, b = 29]}                                                       
   >> assign(op(%)):  a,b, a*b;
                                13, 29, 377

   >> delete z: x:=z: assign(table(x=42)):  x, level(x,1);

                                   42, z

   >> assign([d=hold((1,2,3))]): d;

                                  1, 2, 3
++*/

assign :=
proc(L: Type::Union(DOM_LIST, DOM_SET, DOM_TABLE), S)
begin
  if testargs() then
    if args(0) > 2 or args(0)<1 then
      error("wrong no of args")
    end_if;
    if nops(args(1))>0 and map({op(args(1))}, type) <> {"_equal"} then
      error("First operand must consist of equations")
    end_if;
    if args(0) = 2 and domtype(args(2)) <> DOM_SET then
      error("Second argument must be a set")
    end_if
  end_if;


  L:= select(L, eq -> op(eq, 1) <> op(eq, 2));
  
  if args(0) = 1 then              // assign all equations given in args(1) 
    eval( map([op(L)], subsop, 0=_assign) );
    return(L);
  end_if;
  
  // make assignments only for variables that are listed in S 
  
  
  eval( map([op(
                select( L, ((x,y) -> contains(y,op(x,1))), S )
                )], subsop, 0=_assign ) );
  return(L)
end_proc:

// end of file 
