

// block - Domain of objects protected against evaluation



// basic shape
/*
Blocks are atomic: each one is the only operand of itself, even
if the block contains a sequence
subs, eval, float do nothing
expr does nothing, too
arithmetical operations return unevaluated

*/


domain block
  inherits Dom::BaseDomain;
  category  Cat::BaseCategory;

    new:=
    proc()
      option hold;
    begin
      new(dom,args())
    end;

    convert:= proc(a) begin if a::dom = dom then a else FAIL end_if end;

    nops:= 1;
    
    op:=
    proc(x : dom, n)
    begin
      case args(0)
        of 1 do
          return(x)
        of 2 do
          if domtype(n) <> DOM_INT then
            error("Illegal argument")
          end_if;
          if n<>1 then
            FAIL
          else
            x
          end_if;
          break
      otherwise
          error("Wrong number of arguments")
      end_case
    end_proc;

      
    expr:= id;

    normal:= id;
    
    print := x-> extop(x);
    
    expr2text := x -> expr2text(dom)."(".expr2text(extop(x)).")";

    func_call:= x -> subs(hold(a)(args(2..args(0))),
                          hold(a) = x);

    flatten:= bl -> eval(hold(block)(unblock(bl)));

    _index:= () -> hold(_index)(args());

    _mult:= () -> if args(0) = 1 then
                    args(1)
                  else
                    hold(_mult)(args())
                  end_if
                                                ;


    testtype:= 
    proc(x, T)
    begin
      // domtype(x) = T is done in the kernel, so 
      if T = dom then 
        FAIL
      elif T = Type::Arithmetical then
        TRUE
      else 
        FAIL
      end_if   
    end_proc;
    
    
  end_domain:



// blockTransparent
/*
A transparent block is similar to an object enclosed in hold(...)
It is not evaluated (even not using eval)
but it has operands, and op, subs work as usual
It can be converted into an expression using expr
Arithmetical operations return unevaluated
*/


  
domain blockTransparent

  inherits block;
  category  Cat::BaseCategory; 


    nops:= bl -> nops(extop(bl));

    op:= bl -> op(extop(bl), args(2..args(0)));
    
    subs:= bl -> if args(args(0)) = Unsimplified then
		   new(dom, subs(extop(bl), args(2..args(0))));
		 else
		   new(dom, subs(extop(bl), args(2..args(0)), Unsimplified));
		 end_if;

    subsop:= bl -> if args(args(0)) = Unsimplified then
                     new(dom, subsop(extop(bl), args(2..args(0))));
                   else
                     new(dom, subsop(extop(bl), args(2..args(0)), Unsimplified));
                   end_if;

    evalAt:= bl -> bl;
    
    // this would be undesired because it "unfreezes" int:
    // evalAt:= bl -> new(dom, evalAt(extop(bl), args(2..args(0))));
    
    
    expr:= bl -> extop(bl);
    
    has := bl -> has([extop(bl)], args(2..args(0)));

    _index:= () -> hold(_index)(args());
    
    
    // missing: has, hastype, indets, ...
  end_domain:
  

  

  // blockIdents
  // blocks that evaluate and simplify their input, preventing
  // the substitution of certain identifiers

domain blockIdents(idents: DOM_SET)
  local internalSubstitutions, ind, equ;
  inherits blockTransparent;
  category  Cat::BaseCategory;

    new:=
    proc()
      option hold;
    begin
      new(dom, args());
      eval(%)
    end_proc;
      
    subs:=
    proc(bl)
    begin
      bl:= subs(extop(bl), internalSubstitutions);
      bl:= subs(bl, args(2..args(0)));
      new(dom, subs(bl, internalBackSubstitutions))
    end_proc;

    evaluate:=
    proc(bl)
    begin
      bl:= subs(extop(bl), internalSubstitutions);
      bl:= eval(bl);
      new(dom, subs(bl, internalBackSubstitutions))
    end_proc;


    
  begin
    internalSubstitutions:= [ind = genident("blockInternal")
                             $ind in idents];
    internalBackSubstitutions:= [op(equ, 2) = op(equ, 1)
                                 $equ in internalSubstitutions];
      
  end_domain:

  
  
unblock:=
proc(x, blockdomain, Recurse, do_eval)
  option hold;
  local i: DOM_INT;
begin
  x:= context(x);
  // flattening for 2nd through fourth arg, defaulting to TRUE:
  [blockdomain, Recurse, do_eval] := context([args(3..args(0)), TRUE$3])[1..3];
  if blockdomain = TRUE then
    blockdomain:= block
  end_if;

  if testargs() then
    if domtype(blockdomain) <> DOM_DOMAIN then
      error("second argument must be a domain")
    end_if;
    if domtype(Recurse) <> DOM_BOOL then
      error("Third argument must be boolean")
    end_if
  end_if;
  
  if x::dom::hasProp(blockdomain) = TRUE then
    if do_eval then
      eval(extop(x))
    else
      extop(x)
    end
  elif Recurse then
    if contains({DOM_LIST, DOM_TABLE, DOM_ARRAY, DOM_SET, "_exprseq"},
             type(x)) then
      map(x, unblock, blockdomain, Recurse, do_eval)
    elif domtype(x) = DOM_EXPR then
      unblock(op(x, 0), blockdomain, Recurse, do_eval)
      (unblock(op(x, i), blockdomain, Recurse, do_eval) $i=1..nops(x))
    elif x::dom::unblock <> FAIL then
      x::dom::unblock(x, blockdomain, Recurse, do_eval)
    else
      x
    end_if
  else
    x
  end_if
end_proc:
    