
/*++
complexInfinity -- representing the 'complex infinity' in the compactification of C

There exists only one element 'complexInfinity' of this domain (stdlib::CInfinity)
which has no operands.
++*/

stdlib::CInfinity:= newDomain("stdlib::CInfinity");
stdlib::CInfinity::create_dom:=hold(complexInfinity):
stdlib::CInfinity::info:=
    "domain 'stdlib::CInfinity': representing the complex infinity";
stdlib::CInfinity::interface:= {};

stdlib::CInfinity::expr:= proc() begin complexInfinity end_proc:
stdlib::CInfinity::print:= proc() begin hold(complexInfinity) end_proc:
// stdlib::CInfinity::TeX:= proc() begin "\\infty" end_proc;
stdlib::CInfinity::TeX:= proc() begin "\\text{complexInfinity}" end_proc:

stdlib::CInfinity::testtype:=
proc(x, T)
begin
if T = Type::Arithmetical then
  TRUE
else
  FAIL
end_if
end_proc:


stdlib::CInfinity::_negate:= id;
stdlib::CInfinity::_invert:= proc() begin 0 end_proc:

// disallow all boolean operations
stdlib::CInfinity::_and:=
stdlib::CInfinity::_or :=
stdlib::CInfinity::_not:= proc() begin error("invalid operand") end_proc: 

stdlib::CInfinity::_power:=
proc(base, expo)
begin
  if args(0) <> 2 then
    error("Wrong number of arguments")
  end_if;

  // we may assume that we have been called by overloading

  assert(domtype(expo) = stdlib::CInfinity or
         domtype(base) = stdlib::CInfinity);
  
  case domtype(expo)
    of stdlib::CInfinity do
      case domtype(base)
        of stdlib::CInfinity do
        of stdlib::Infinity do  
        of stdlib::Undefined do
        of DOM_RAT do
        of DOM_COMPLEX do  
          return(undefined)
      end_case;
      // undefined unless base = 1
      return(piecewise([base = 1, 1]))      

      // in all other cases, base = compexInfinity
      
    of DOM_FLOAT do
      if iszero(expo) then
        return(1.0)
      elif expo < 0 then
        return(0.0)
      else
        return(complexInfinity)
      end_if;
    of DOM_INT do
      if expo = 0 then
        return(1)
      end_if;
      // else fall through
    of DOM_RAT do
      if expo < 0 then
        return(0)
      else
        return(complexInfinity)
      end_if;
    of DOM_COMPLEX do
      return(complexInfinity)
    otherwise
      return(piecewise([expo < 0, 0],
                       [expo = 0, 1],
                        [not expo <= 0, complexInfinity]))
  end_case
end_proc:

stdlib::CInfinity::_plus:= proc()
    local y;
begin
    y := split([args()], _equal, complexInfinity);
    if nops(y[1]) > 1 or map({op(y[2])}, domtype) intersect
	{stdlib::Undefined, stdlib::Infinity} <> {}
    then
        undefined
    else 
        complexInfinity
    end_if
end_proc;

stdlib::CInfinity::_mult:= proc() begin
    _mult(op(select([args()], not (stdlib::CInfinity)::thisDomain)));
    if % = undefined or iszero(%) then undefined else complexInfinity end_if
end_proc;

stdlib::CInfinity::intmult:= proc() begin
    if iszero(args(2)) then undefined else complexInfinity end_if
end_proc;

stdlib::CInfinity::subs:= proc() begin
    if op(args(2),1) = complexInfinity then
        op(args(2),2)
    else
        complexInfinity
    end_if
end_proc;

stdlib::CInfinity::subsop:= proc() begin
    if args(2) = 1 then args(3) else FAIL end_if
end_proc;

stdlib::CInfinity::op:= proc() begin
    if args(0) = 2 then
        if args(2) = 1 then complexInfinity else FAIL end_if
    else 
        complexInfinity
    end_if
end_proc;

stdlib::CInfinity::has:= proc() begin bool(args(2) = complexInfinity) end_proc;

stdlib::CInfinity::O:= proc() begin undefined end_proc;

stdlib::CInfinity::thisDomain:= proc() begin
    bool(domtype(args(1)) = stdlib::CInfinity)
end_proc;

complexInfinity:= new(stdlib::CInfinity);

// end of file 
