//    

// kg, 10/12/93 

/*++
content -- content of a polynomial or polynomial expression

content(poly)
content(expr, [ind,...])

poly - polynomial
expr - polynomial expression
ind  - indets (optional)
++*/

content:=
proc(p)
local n;
// option remember; 
// Replaced option remember by prog::remember,
// since option remember is one hell of a
// memory consumer!
begin
  if testargs() then
    // test for correct number of args 
    if args(0) = 0 then
      error("wrong no of args")
    end_if;
    if domtype(p) = DOM_POLY then
      if args(0) > 1 then
        error("wrong no of args")
      end_if
    else
      if args(0) > 2 then
        error("wrong no of args")
      end_if;
      if args(0) = 2 then
        if domtype(args(2)) <> DOM_LIST then
          error("invalid indeterminate list")
        end_if
      end_if
    end_if
  end_if;

    // allow for overloading 
  if p::dom::content <> FAIL then
    return(p::dom::content(args()))
  end_if;

    // convert expression to poly 
  if domtype(p) <> DOM_POLY then
    if type(p) = "_mult" then
       // In principle, content should be multiplicative:
       // content(p*q) = content(p)*content(q). However,
       // beware: content(x) = 1, content(I) = FAIL 
       // but content(x*I) = 1 !!!
       // So we cannot do:
       // return(map(p, content, args(2..args(0))));
       // Here is a workaround:
       p:= map([op(p)], content, args(2..args(0)));
       if select(p, _not@_equal, FAIL) = [] then
          // return FAIL, if all factors of a product produce FAIL:
          return(FAIL);
       elif has(p, FAIL) then
          // return 1, if some factors produce FAIL while others do not:
          return(1);
       else
          // no problem in any factor, apply the mupltiplicative law:
          return(_mult(op(p)));
       end_if;
    elif type(p) = "_power" then
       n:= op(p, 2); 
       if domtype(n) = DOM_INT then
          if n < 0 then
            return(FAIL)
          else
            return(content(op(p, 1), args(2..args(0)))^n);
          end_if;
       else
         return(1);
       end_if:
    end_if:
    if args(0) = 2 then
      p:= poly(p, args(2), Expr)
    else
      case domtype(p)
        of DOM_INT do
          return(abs(p));
        of DOM_RAT do
          return(abs(p));
      end_case;
      p:= poly(p, Expr)
    end_if;
    if p = FAIL then
      return(FAIL)
    end_if;
  end_if;

  if iszero(p) then
    return(tcoeff(p))
  end_if;
  
  if domtype(op(p,3)) = DOM_DOMAIN then
    (op(p,3))::gcd(coeff(p))
  elif op(p,3) = hold(Expr) then
    case gcdlib::coeff_type([p])
      of DOM_INT do
        igcd(coeff(p)); break;
      of DOM_RAT do
        gcd(coeff(p)); break;
      of DOM_FLOAT do 1; break;
      of DOM_COMPLEX do 1; break;
      of DOM_EXPR do
        if contains(map([coeff(p)], poly), FAIL) <> 0 then
          1
        else
          gcd(coeff(p))
        end_if;
    end_case;
  elif isprime(op(p,[3,1])) then
    1
  else
    error("not a prime modulus")
  end_if
end_proc:

content:= prog::remember(content):

// end of file 
