//    

// kg, 19/01/94 

/*++
denom -- the denominator of a rational expression

denom(x <, options>)

x - expression
options - the same options as for normal, except that List is not permitted
++*/

denom:=
proc(x)
  local options, optiontypes, normaloptions, tmp;
begin
  if args(0) = 0 then
    error("denom called without arguments")
  end_if;
  if x::dom::denom <> FAIL then
    return(x::dom::denom(x))
  end_if;
  if testargs() then
    if not testtype(x, Type::Arithmetical) then
      error("no arithmetical expression")
    end_if;
  end_if;

  if args(0) >= 2 and type(args(2)) = DOM_TABLE then
    options:= args(2);
    optiontypes:= null();
  else
    // we accept the same options as normal, but not the option List
    options:= table(normal::defaultOptions, args(2..args(0)));
    optiontypes:= normal::optiontypes;
    delete options[List], optiontypes[List];
  end_if;

  tmp:= prog::getOptions(2, [args()], options, TRUE, optiontypes);
  if nops(tmp) = 0 then
     normaloptions:= null();
  else
     normaloptions:= tmp[1];
  end_if;
  normaloptions[List]:= TRUE;
  
// main part (old stdlib::denom)
  
  case type(x)
    of DOM_INT do
      1;
      break;
    of DOM_RAT do
      op(x,2);
      break;
    of DOM_COMPLEX do
      case domtype(op(x,1))
        of DOM_INT do
          case domtype(op(x,2))
            of DOM_INT do
              1;
              break;
            of DOM_RAT do
              op(x,[2,2]);
              break;
            otherwise
              1.0;
          end_case;
          break;
        of DOM_RAT do
          case domtype(op(x,2))
            of DOM_INT do
              op(x,[1,2]);
              break;
            of DOM_RAT do
              op(x,[1,2])*op(x,[2,2]) /
              igcd(op(x,[1,2]), op(x,[2,2]));
              break;
            otherwise
              1.0;
          end_case;
          break;
        otherwise
          1.0;
      end_case;
      break;
    of "_mult" do
      map(x, denom, options);
      break;
    of "_power" do
      if domtype(op(x,2)) = DOM_INT then
        if op(x,2) > 0 then
          denom(op(x,1), options) ^ op(x,2)
        else
          numer(op(x,1), options) ^ (-op(x,2))
        end_if
      else
        normal(x, normaloptions)[2]
      end_if;
      break;
    otherwise
      normal(x, normaloptions)[2];
  end_case
 end_proc :
