// 

// Platzhalter, Code kommt von Fu

// stdlib::diff := () -> hold(diff)(args()):

stdlib::diff:= proc(f,x)
  local var, var2, i, j, m, n;
  option noDebug;
begin
  var:=  args(args(0));
  var2:= args(2..args(0)-1);
  if type(f) = DOM_LIST then
    if type(var) = DOM_IDENT or type(var) = "_index" and type(op(var,1)) = DOM_IDENT then 
      /* 
      If f is a list an var an identifier, then we want to 
      compute the column pseudo tensor 
                    +-                    -+
                    |  diff(f1(var), var)  |
                    |                      |
                    |  diff(f2(var), var)  |
                    |                      |
                    |         ....         |
                    +-                    -+
      */
      return(Dom::PseudoTensor()(map(f, diff, var2, var)));
    elif type(var) = DOM_LIST then 
      /*
      If f and x are both lists, then we want to compute the 
      matrix pseudo tensor corresponding to the Jacobi matrix:
         ( diff(f[i],var[j]) ), 1 <= i <= nops(f), 1 <= j <= nops(x)
      */
      return(Dom::PseudoTensor()([[diff(f[i],var2,var[j]) $ j = 1..nops(var)] $ i = 1..nops(f)]));
    else 
      return(hold(diff)(args()))
    end_if;
  elif type(f) <> DOM_LIST and type(var) = DOM_LIST then
    if f::dom::constructor = Dom::PseudoTensor then
      [m,n]:= f::dom::matdim(f);
      if nops(var) > 1 then 
        return(Dom::PseudoTensor()(m, n, [[diff(f[i,j],var2,var) $ j = 1..n] $ i = 1..m]));
      else
        return(Dom::PseudoTensor()(m, n, [[diff(f[i,j],var2,op(var)) $ j = 1..n] $ i = 1..m]));
      end_if;  
    elif f::dom::constructor = Dom::Matrix then
      [m,n]:= f::dom::matdim(f);
      //f:= Dom::PseudoTensor()(m,n,f);
      if nops(var) > 1 then 
        return(Dom::PseudoTensor()(m, n, [[diff(f[i,j],var2,var) $ j = 1..n] $ i = 1..m]));
      else
        return(Dom::PseudoTensor()(m, n, [[diff(f[i,j],var2,op(var)) $ j = 1..n] $ i = 1..m]));
      end_if;  
    else
      if iszero(f) then 
        return(0) 
      else
        return(Dom::PseudoTensor()(1,nops(var), [[diff(f,var2,var[i]) $ i = 1..nops(var)]]));  
      end_if;
    end_if;
  else 
    return(hold(diff)(args()))
  end_if;
end_proc:

