/* doprint serves for letting objects print themselves
   via their doprint method -- if they have one.
   Presently, these are matrices that are not willing
   to print themselves if they are too large.
   The matrix::doprint method enforces a sparse table 
   like output of the matrix.

   For all other objects doprint acts like print.
*/

doprint :=
ex ->
   if args(0) <> 1 then
     print(map(args(), misc::maprec,
               (x -> bool(x::dom::doprint <> FAIL)) =
               (x -> x::dom::doprint(x))))
   else
     print(misc::maprec(ex,
                        (x -> bool(x::dom::doprint <> FAIL)) =
                        (x -> x::dom::doprint(x)))):
   end_if:
