//   


/// _equiv (a, b)
///
//  boolean operator, equivalent to (not a and not b) or (a and b)
//


_equiv:= funcenv
(proc(x, y)
   name _equiv;
 begin
   if args(0)<>2 then
     error("Wrong number of args")
   end_if;
   if {x, y} intersect {TRUE, FALSE} <> {} then
     not x and not y or x and y
   else  
     procname(args())
   end_if
 end_proc,
 builtin(1097, 50, " <=> ", "_equiv" )):
// do not touch the priority; has to be consistent with the
// MuPAD parser and output::Priority (Typesetting)

_equiv::type  := "_equiv":
_equiv::print := "_equiv":

_equiv::bool :=
proc(x, y)
begin
  bool(not x and not y or x and y)
end_proc:

_equiv::float:= (x, y) -> hold(_equiv)(float(x), float(y)):

_equiv::TeX := 
  (arg1, arg2, arg3) -> generate::TeXoperator(" \\Longleftrightarrow ",
                                              arg3, output::Priority::Equiv,
                                              op(arg2)):
_equiv::Content := stdlib::genOutFunc("Cequiv", 2):

`<=>` := _equiv:

