// 

/* factorout.mu
 *
 * factorization of terms
 */

factorout := proc(x, f, list = FALSE)
  local d, F, fd, fn, n;
begin

  // Local procedure F

  F := proc(f, x, list = FALSE)
  begin

    if list = TRUE then
       return([f, x])
    end;

    if testtype(f, Type::Numeric) then
       // f * x would be automatically expanded.
       // We avoid this by creating an object of
       // type Factored.
       // Do not use Factored::create(f*x), use
       // f * Factored::create(x)
       // We use hold(_mult)(f, Factored::create(x))
       // instead of f * Factored::create(x)
       // just for "cosmetic" reasons.
       hold(_mult)(f, Factored::create(x))
    elif testtype(x, Type::Numeric) then
       // We use hold(_mult)(x, Factored::create(f))
       // instead of x * Factored::create(f)
       // just for "cosmetic" reasons.
       hold(_mult)(x, Factored::create(f))
    else
       // We use hold(_mult)(f, x) instead of f * x
       // just for "cosmetic" reasons.
       hold(_mult)(f, x)
    end
  end;

  // Main procedure

  if args(0) < 2 then
     error("At least 2 arguments expected.")
  end;

  if f = 0 then return( x ) end;

  if poly(x) = FAIL then
     // Check if x is a rational expression, e.g. x = n / d
     d := denom(x);
     if d = 1 then
        F( f, Simplify(x/f), list)
     else
        n := numer(x);
        fd := denom(f);
        if fd = 1 then
           //factorout(n, f) / d
           fd := factorout(n, f, TRUE);
           hold(_mult)(f, fd[2]/d)
        else
           fn := numer(f);
           if fn = 1 then
              //n / factorout(d, fd)
              fd := factorout(d, fd, TRUE);
              hold(_mult)(hold(_divide)(1,fd[1]), n/fd[2])
           else
              //factorout(n, fn) / factorout(d, fd)
              fn := factorout(n, fn, TRUE);
              fd := factorout(d, fd, TRUE);
              hold(_mult)(fn[1]/fd[1], fn[2]/fd[2])
           end
        end
     end
  else
     F( f, mapcoeffs(x, t -> Simplify(t/f) ), list )
  end
end:
