/* ----------------------
forget -- erase entries from a remember table

Calls: 

  forget(f)                 // erase *all* entries in the remember table of f
  forget(f(x1), f(x2), ...) // erase f(x1) etc in the remember table of f

Parameters:
  f - a DOM_PROC or a DOM_FUNC_ENV
  x1, x2, ...  -- whatever is accepted by f
-------------------------- */

forget:= proc(f)
local op0, remTableIndex, remTable, x;
option hold;
begin
  if args(0) = 0 then 
     error("expecting at least one argument");
  end_if:

  // forget(f(x0), f(x1), ...)
  if args(0) > 1 then
     map([args()], forget);
     return():
  end_if:

  if domtype(f) <> DOM_EXPR then
     // forget(f) = erase *all* remembered entries
     op0:= f;
     x:= NIL;
  else
     op0:= context(hold(op)(hold(hold)(f), 0)):
     x:= op(context([op(f)])):
  end_if;

  remTableIndex:= FAIL;
  remTable:= NIL;
  case domtype(context(op0)) 
  of DOM_PROC do
     remTableIndex:= 5;
     remTable:= op(context(op0), remTableIndex); 
     break;
  of DOM_FUNC_ENV do
     remTableIndex:= [1, 5];
     remTable:= op(context(op0), remTableIndex); 
     break;
  otherwise
     return();
  end_case:
  if remTable = NIL or nops(remTable) = 0 then
     return();
  end_if:
  if x = NIL then
     remTable:= NIL;
  else
     delete remTable[x];
  end_if:
  if nops(remTable) = 0 then
     remTable:= NIL;
  end_if;
  context(hold(sysassign)(op0, hold(subsop)(op0, remTableIndex = remTable)));
  return();
end_proc:

