stdlib::frozen := newDomain(hold(stdlib::frozen)):
stdlib::frozen::create_dom := hold(stdlib::frozen):
stdlib::frozen::evaluate := proc(e) begin extop(e,2) end:
// stdlib::frozen::print := proc(e) begin "~".expr2text(extop(e,1)) end:
stdlib::frozen::print := proc(e) begin extop(e,1) end:
stdlib::frozen::expr := proc(e) begin hold(freeze)(extop(e,1)) end:
stdlib::frozen::domtype := proc(e) begin domtype(extop(e,1)) end:
stdlib::frozen::type := proc(e) begin type(extop(e,1)) end:
stdlib::frozen::subs:= proc(e) begin e end_proc:
stdlib::frozen::evalAt:=FAIL;
stdlib::frozen::func_call :=
proc(e)
begin
  context(subsop(hold(F)(args(2..args(0))), 0=e, Unsimplified))
end_proc:

/*
freeze -- make function inactive

freeze(f)

f - function

freeze(f) returns a function which is an 'inactive' version of f.
The function returned by freeze:
- only evaluates its arguments, but does not compute anything else,
- prints like f and has the same expression type as f,
- has all the functional attributes of f.

freeze is used for example to create inactive functions to be
returned instead of expensive functions like 'int'. The inactive 'int'
is returned if the expression can not be integrated further in order to
avoid re-evaluation of 'int'.

Use 'unfreeze' to re-activate the function.
*/

freeze:=
proc(f)
  option escape, hold;
  local v, F, v_orig;
begin
  v:= context(f);
  F := v;
  if contains(stdlib::freeze_rememberTable, F) then
    return(stdlib::freeze_rememberTable[F])
  end_if;
  if domtype(v) <> DOM_FUNC_ENV then
    if domtype(v) <> DOM_PROC then
      error("expecting a procedure or a function environment")
    else
      v := funcenv(v)
    end_if;
  else
    // v is a funcenv;  make sure that all slot loadprocs are resolved
    prog::init(v)
  end_if;
  v_orig := v;
  v:= subsop(v,
             1=proc()
                 option noDebug;
               begin
                 subsop(hold(FF)(args()), 0=f)
               end);
  v::unfreeze := v_orig;
  v::evalAt := FAIL;
  if domtype(F) = DOM_PROC then
    if op(F, 6) <> NIL then
      v := subsop(v, [1, 6] = op(F, 6));
    end_if;
  elif domtype(F) = DOM_FUNC_ENV and F::Name = FAIL and
    domtype(op(F, 1)) = DOM_PROC then
    if op(F, [1, 6]) <> NIL then
      v := subsop(v, [1, 6] = op(F, [1, 6]));
    end_if;
  end_if;
  f:= new(stdlib::frozen, f, v);
  sysassign(stdlib::freeze_rememberTable[F], v);
  v
end_proc:

stdlib::freeze_rememberTable:= table():


/*
unfreeze -- re-activate inactive funtion

unfreeze(f)

f - inactive function or functional expression created by 'freeze'

unfreeze(f) returns the active version of an inactive function
which has been created by 'freeze'. Use 'subsop(e,
0=unfreeze(op(e,0)))' to unfreeze an expression where the operator
has been frozen.
*/

unfreeze:=
proc(e) 
  local f;
begin
  if args(0) <> 1 then error("expecting one argument") end_if;
  if (f:= stdlib::unfreeze_apply(e)) = FAIL then
    // apply unfreeze recursively to the operands of e:
    return(
           misc::maprec
           ( e,
            proc(x)
            begin
              bool(stdlib::unfreeze_apply(x,hold(Check)) <> FAIL)
            end_proc
            = stdlib::unfreeze_apply, hold(PostMap) )
           )
  else
    return( f )
  end_if
end_proc:

stdlib::unfreeze_apply:=
proc(e)
  local f;
begin
  if e::dom::unfreeze <> FAIL then
    return(e::dom::unfreeze(args()));
  end_if;
  if domtype(e) <> DOM_FUNC_ENV then
    if domtype(e) = DOM_EXPR and domtype((f:= eval(op(e,0)))) = DOM_FUNC_ENV
      then
      f:= slot(f, "unfreeze");
      if f <> FAIL then
        if args(2..args(0)) = hold(Check) then
          return( TRUE )
        else
          return(eval(subsop(map(e, unfreeze), 0=f)))
        end_if
      end_if
    end_if;
    return( FAIL )
  else
    return( slot(e, "unfreeze") )
  end_if
end_proc:

