/*++ ---------------- ground.mu ---------------------
  ground(poly)
  ground(expr <,indets>)

     indets --> [expr_1,...] 
  
  poly        -- polynomial
  expr,expr_1 -- expressions

  computes the ground term of a polynomial or a polynomial expression f
  with respect to indets, i.e. that term in which indets do not occur. 
  If f is an expression, f is first converted into a polynomial or, 
  if that fails, FAIL is returned.
  If indets is not given, the ground term is computed with respect to 
  the indeterminates of the polynomial.
    
++*/

ground:=
proc(p)
local vl,R,pl,n;
begin
  if args(0)=0 then
    error("ground called without arguments")
  end_if;
  if p::dom::ground <> FAIL then
    return(p::dom::ground(args()))
  end_if;
  
  if args(0)=2 then
    if domtype(p)=DOM_POLY then error("Wrong number of arguments") end_if;
    if type((vl:=args(2)))<>DOM_LIST then error("Illegal arguments") end_if;
  else vl:=null()
  end_if;

  case domtype(p)
    of DOM_INT do;
    of DOM_RAT do;
    of DOM_IDENT do;
    of DOM_EXPR do if (p:=poly(p,vl))=FAIL then return(FAIL)
                     //error("Cannot convert to polynomial")
                   end_if; 
    of DOM_POLY do R:=op(p,3); break;
    otherwise
      error("Illegal argument")
  end_case;

  pl:=poly2list(p);
  n:=nops(pl);
  case bool(n>0)
    of TRUE do if {op(pl[n][2])}={0} then return(pl[n][1]) end_if;
    otherwise
      if domtype(R)=DOM_DOMAIN then return(R::zero) else return(0) end_if;
  end_case;
end_proc:

// end of file 












