/* hastype(x,t) checks if x contains a subexpression of type t
  hastype(x,{t1,t2,...}) checks if x contains a subexpression of type t1 or t2 or ...

  hastype recurses into the same types of subexpressions as maprec does,
  plus all that are element of the third argument.
                                  
  Examples:

  >> hastype(1+x,DOM_FLOAT);

                                   FALSE
  >> hastype(1.0+x,DOM_FLOAT);

                                   TRUE
  >> hastype(x+y,"_plus");

                                   TRUE
  
  >> hastype(x+y,{DOM_COMPLEX,DOM_RAT});

                                   FALSE

  >> hastype( 2+1/x,Type::Union( DOM_INT,DOM_IDENT ) );

                                   TRUE

  >> hastype(proc() begin 3.0 end, DOM_FLOAT); 

                                   FALSE
                                  
  >> hastype(proc() begin 3.0 end, DOM_FLOAT, {DOM_PROC});

                                   TRUE
                                
*/

hastype :=
proc(x,t, gointo={}:DOM_SET)
  local e, found;
begin
  if args(0) = 0 then
     error("hastype called without arguments")
  end_if;

  if x::dom::hastype <> FAIL then
    return( x::dom::hastype(args()) )
  end_if;

  if args(0) =1 then 
    error("Second argument missing")
  end_if;

  case domtype(t)
    of Type do
      e:= x -> testtype(x,t);
      break
    of DOM_SET do
      e:= t;
      break
    of DOM_LIST do
      e:= {op(t)};
      break
    otherwise
      e:={t}
  end_case;

  found:= FALSE;
  misc::maprec(x, e=
               proc()
               begin
                 misc::breakmap();
                 found:= TRUE;
                 args()
               end_proc,
               gointo=
               proc(a)
               begin
                 if a<>op(a) then
                   // to avoid infinite recursion
                   if hastype([op(a)], t, gointo) then
                     misc::breakmap();
                     found:=TRUE;
                   end_if
                 end_if;
                 a
               end_proc, Unsimplified);
  found;
end_proc:

