//    
// 
// new version by Walter, 27.10.99 

/*
Todo:

(13.3.01)
fuer den 1-dim Fall von Lagrange-Darstellung auf Newton-Darstellung
umgestellt. Dies gibt enormen Laufzeitgewinn im Fall von poly-Rueckgaben.

Es fehlt noch die Umstellung des mehrdimensionalen Falls von
Lagrange auf Newton.

*/

/*++

	interpolate - polynomial interpolation of data over a
                   d-dimensional rectangular grid
			
Call(s)
	interpolate(xList, valueList, x <,F>)
	interpolate([xList, yList, zList,..], values, [x,y,z,..] <,F>)

Parameters:
	xList  --  [x1,x2,..,x.nx]
        yList  --  [y1,y2,..,y.ny]
        zList  --  [z1,z2,..,z.nz]
          ..
        valueList -- [v1,v2,..,v.nx]
	values -- array(1..nx, 1..ny, 1..nz, .. ) or
	          hfarray(1..nx, 1..ny, 1..nz, .. )
                  of values:
	x,y,z --  indeterminates (DOM_IDENT or type(..) = "index" 
                  or arbitrary expressions, numbers etc.

Options:
	F     --- (optional) coefficient field, default is Expr


Return Value:
   Returns the polynomial P (domtype DOM_POLY) of lowest degree 
   with indeterminates x, y, z, ..  which interpolates the given data,
   i.e. 
           P(x.i, y.j, z.k, ..) = values[i,j,k,..],
           degree(P,x) <= nx, degree(P,y) <= ny, etc.

Details:
  If any of x, y, z, .. is not an indeterminate (DOM_IDENT or
  type(..)="_index") then the evaluation of the interpolating
  polynomial at that point is returned.

Option Details
  poly( .., F) is returned with the default F=Expr.
  Any F<>Expr must be of Cat::Field.
  F::convert must be able to handle the operands of xList, yList, ..
  as well as the operands of the "values" array.

Examples:
  >> xList:= [1, 2, 3]:
  >> fList:= [f(1), f(2), f(3)];
  >> nodes:= [xList]: 
  >> values:= array(1..3, fList):
  >> interpolate(nodes, values, [x], Expr);

           / / f(1)          f(3) \  2   /          5 f(1)   3 f(3) \
       poly| | ---- - f(2) + ---- | x  + | 4 f(2) - ------ - ------ | x +
           \ \  2             2   /      \            2        2    /
       
                                        \
          (3 f(1) - 3 f(2) + f(3)), [x] |
                                        /

  >> xList:= [1, 2, 3]:
  >> yList:= [3, 4]:
  >> nodes:= [xList, yList]:
  >> values:= array(1..3,1..2,[[1,2], [3,4], [5,6]]):
  >> interpolate(nodes, values, [x, y]);

                      poly(2 x + y - 4, [x, y])

  >> interpolate(nodes, values, [3, y]);

                           poly(y + 2, [y])

  >> interpolate(nodes, values, [x, sin(1)]);
 
                    poly(2 x + (sin(1) - 4), [x])

  >> interpolate(nodes, values, [3, sin(1)]);

                              sin(1) + 2

  // compare timings for old and new version:
  >> F:= Dom::AlgebraicExtension(Dom::Rational, Sqrt2^2=2, Sqrt2): 
     F:= Expr:
     n:= 20: xList:= [i $ i=1..n]:
     m:= 20: yList:= [j $ j=1..m]:
     nodes:= [xList, yList]:
     fList:= [[1/(i+j)$j=1..m]$i=1..n]:
     values := array(1..n,1..m,fList):
     time( ( p1:=
     interpolate(nodes,values, [x,y], F)
        ))*msec;

                          280870 msec (for F = Dom::AlgebraicExt...)
                           63570 msec (for F = Expr)

             
     // compare to old implementation:
     time( ( p2:=
         numeric::lagrange2d([xList,yList],fList, [x,y], F)
     ))*msec;

                          587120 msec (for F = Dom::AlgebraicExt...)
                           87900 msec (for F = Expr)


     // old and new version coincide:
     p1-p2;

                     poly(0, [x, y], Dom::Algebraic....);


++*/

interpolate:=proc(nodes, values, x)
local F, Fone, One, ZeroExpo, d, L, tmp, i, j, n, k, xx, position,
      N, ind, result;
begin
  if args(0)<3 then error("expecting at least 3 arguments"); end_if;
  if args(0)>4 then error("expecting at most 4 arguments"); end_if;
  F:=hold(Expr); Fone:=1; // default 
  if args(0)=4 then
     F:=args(4);
     if F = Dom::ExpressionField() then F:= hold(Expr) end_if;
     if F<> hold(Expr) then
       if F::hasProp(Cat::Field) <> TRUE 
       then error("Third argument must be of category Cat::Field");
       end_if;
       Fone:= F::one;
       if Fone=FAIL
       then error("No neutral element (".expr2text(F).")::one found");
       end_if;
     end_if;
  end_if;

  // ----- check and prepare evaluation point -------
  if domtype(x)<>DOM_LIST then x:= [x] end_if;
  d:= nops(x);
  if F<>hold(Expr) then 
    for i from 1 to d do
      if domtype(x[i])<>DOM_IDENT and type(x[i])<>"_index" 
      then // convert component of input vector to domain F:
           x[i]:= map(x[i],F):
           if has(x[i], FAIL)
           then error("could not convert interpolation point to a field element") 
           end_if;
      end_if;
    end_for;
  end_if;

  //--------------------------------------------------------------
  // --- special case interpolate(xList, yList, ind <, F>) ---
  // convert to interpolate([xList], array(1..n, yList), ind <, F>
  // and proceed as with the generic input format
  //--------------------------------------------------------------
  if domtype(values) = DOM_HFARRAY then
     values:= array(op(values, [0, i]) $ i = 2 .. op(values, [0, 1]) + 1, 
                    [op(values)]);
  end_if: 

  if domtype(values) <> DOM_ARRAY then
     if domtype(values) <> DOM_LIST then
        error("expecting a list, array, or hfarray of values");
     end_if;
     values:= array(1..nops(values), values);
     if domtype(nodes) <> DOM_LIST then
        error("expecting a list of nodes");
     end_if;
     nodes:= [nodes];
  end_if; 


  // ----- check and prepare nodes -------
  if domtype(nodes)<>DOM_LIST then 
     error("First argument must be a list");
  end_if;
  if {op(map(nodes, domtype))}<>{DOM_LIST} then
     error("First argument must be a list of lists");
  end_if:
  if nops(nodes) <> d then
     error("need ".expr2text(d)." node list(s) for ".expr2text(d)." indeterminate(s)");
  end_if;
  // dimension n=[n1,n2,..] of rectangular (n1 x n2 x ..) grid:
  n:= map(nodes, nops):
  for i from 1 to d do
    if nops({op(nodes[i])})<> n[i] then 
     error("All nodes must be distinct");
    end_if;
  end_for;

  // ----- check and prepare values -------
  if domtype(values)<>DOM_ARRAY then 
     error("Second argument must be an array");
  end_if;
  if op(values, [0,1])<>d then
     error("A ".expr2text(d)."-dimensional grid requires a ".
                expr2text(d)."-dimensional array of values");
  end_if:
  if [op(values, [0,1+j,2]) $ j=1..d] <> n then
     error("Mismatch of grid and array of values");
  end_if;

  // ----- convert all input to data to domain F:
  if F<>hold(Expr)
  then nodes:= map(nodes, map, F);
       if has(nodes, FAIL) then
          error("could not convert interpolation nodes to field elements")
       end_if;
       values:= map(values, map, F);
       if has(values, FAIL) then
          error("could not convert interpolation values to field elements")
       end_if;
  end_if;
  // conversion done

  //-----------------------------------------------------------
  //-----------------------------------------------------------
  // Now do the interpolation:
  //-----------------------------------------------------------
  // ---------------  dimension = 1 ---------------------------
  if d=1 then 
     x:= x[1];
     n:= n[1];

     // use a standard Newton scheme. This is the fastest, both
     // for evaluation at points as well as for symbolic polynomials.
     // (Note that the expensive part is the expansion when building
     // up the polys. The Newton scheme minimizes these costs.)

     // compute divided differences
     for j from 1 to n-1 do
       for i from n downto j+1 do
         tmp := nodes[1][i]- nodes[1][i-j];
         if iszero(tmp) then
            error("the nodes must be distinct"):
         end_if;
         values[i]:= (values[i]-values[i-1])/tmp;
       end_for:
     end_for:

     // now values contains the divided differences;
     // do Newton interpolation
     if domtype(x) = DOM_IDENT or type(x)="_index" 
     then // x is symbolic, return a poly
          values:= map(values, poly, [x], F);
          if has(values, FAIL) then 
             error("could not convert value(s) to ".expr2text(F));
          end_if;
          L:= values[n];
          for i from n-1 downto 1 do
             L:= poly([[Fone, 1],[-nodes[1][i], 0]], [x], F)*L + values[i];
          end_for:
          if has(L,FAIL) then
             error("arithmetical step in ".expr2text(F)." failed");
          end_if;
          return(L);
     else // x is a domain element, return a domain element
          // Use the overloaded arithmetic in the coefficient domain:
          L:= values[n];
          for i from n-1 downto 1 do
             L:= (x - nodes[1][i])*L + values[i];
          end_for:
          return(L);
    end_if;
  end_if; // if dimension = 1

  // ---------------  dimension > 1 ---------------------------

  // delete specified interpolations points from the list of
  // indeterminates, i.e., x = [x1,2,x3] -> xx = [x1,x3]
  xx:= map(x, proc(y) begin
                  if domtype(y) = DOM_IDENT or type(y)="_index"
                  then return(y) else return(null()) end_if end_proc):
  if xx<>[] then
    ZeroExpo:= [0 $ nops(xx)]; // zero order monomial of list input to poly
  end_if;

  for j from 1 to d do
    if domtype(x[j]) = DOM_IDENT or type(x[j])="_index"
    then // x[j] is symbolic. Let poly take care of the arithmetic in F.

         // prepare input of polynomial x[j]-value for multivariate
         // poly( x[j]-value, [xx[1],xx[2],..]) by a list.
         // Find position of x[j] in list xx:
         position:= contains(xx, x[j]);
         One:=[Fone, [0$position-1, 1, 0 $ nops(xx)-position] ];

         // Compute (univariate) Lagrange polynomial in x[j]
         // associated with i-th node of variable x[j]. It
         // is represented as a multivariate poly in [xx[1],xx[2],..]
         // to avoid later conversion to multivariate L[j,i].
         // The overhead due to dense poly exponents is minimal, because
         // dimension d is small:
         for i from 1 to n[j] do
           L[j,i]:= _mult(poly([One,[-nodes[j][k],ZeroExpo]],xx,F) $ k=1..i-1) *
                    _mult(poly([One,[-nodes[j][k],ZeroExpo]],xx,F) $ k=i+1..n[j]);
           // watch out: evalp(L[j,i], x[j]=value) can produce either
           // poly(.., the_other_variables) (of order zero) or an element of F.
           // We need the zero order element.
           // The following op(poly2list(evalp(..)),[1,1])) works for all cases:
           L[j,i]:=  mapcoeffs(L[j,i],_divide, 
                     op(poly2list(evalp(L[j,i],x[j]=nodes[j][i])),[1,1])
                              );
           if has(L[j,i], FAIL) then 
              error("arithmetical step in ".expr2text(F)." failed");
           end_if;
         end_for;
    else // x[j] is of domtype(F). Use overload basic arithmetic.
         // This is faster than using poly as a container:
         for i from 1 to n[j] do
           if i = 1 then
              L[j,i]:= _mult(  x[j]     -nodes[j][k] $ k=i+1..n[j])/
                       _mult(nodes[j][i]-nodes[j][k] $ k=i+1..n[j]); 
           elif i = n[j] then
              L[j,i]:= _mult(  x[j]     -nodes[j][k] $ k=1..i-1) /
                       _mult(nodes[j][i]-nodes[j][k] $ k=1..i-1);
           else    
              L[j,i]:= _mult(  x[j]     -nodes[j][k] $ k=1..i-1) *
                       _mult(  x[j]     -nodes[j][k] $ k=i+1..n[j])/
                       _mult(nodes[j][i]-nodes[j][k] $ k=1..i-1) /
                       _mult(nodes[j][i]-nodes[j][k] $ k=i+1..n[j]); 
           end_if; 
           if has(L[j,i], FAIL) then 
              error("arithmetical step in ".expr2text(F)." failed");
           end_if;
           // convert L[j,i] to a zero order poly to be able to sum
           // the Lagrange polynomials later:
           if xx<>[] then L[j,i]:= poly(L[j,i],xx,F); end_if;
         end_for;
    end_if;
  end_for;

  // convert values to a zero order poly to be able to sum later:
  if xx <> [] then
    values:= map(values, poly, xx, F);
  end_if;

  // If xx= [] then L[i,j] and values are all elements of F.
  // If xx<>[] then L[i,j] and values are all poly(.., xx, F).
  // In both cases we can use _plus and _mult to compute the
  // following linear combinations:
  // d=1: return(_plus(L[1,i1]*values[i1] $ i1=1..n[1]))
  // d=2: return(_plus(L[1,i1]*L[2,i2]*values[i1,i2]
  //                   $ i1=1..n[1] $ i2=1..n[2]))
  // d=3: return(_plus(L[1,i1]*L[2,i2]*L[3,i3]*values[i1,i2,i3] 
  //                   $ i1=1..n[1] $ i2=1..n[2] $ i3=1..n[3]))
  // Save memory by summing term by term, implementing the d-fold
  // summation in the following way (it's even a bit faster!)
  //-------------------------
  //  Do d-fold summation: 
  //  sum_{i.1=1}^{n[1]} ... sum_{i.d=1}^{n[d]}(
  //      values[i.1,..,i.d]*L[1,i.1]*..*L[d,i.d] )
  // Idea: let i=1..n[1]*..*n[d] run through all operands of
  // the array "values". To each i compute the corresponding
  // index set  op(values,i) = values[ind[1],..,ind[d]].
  // Do this by starting with  i=1  <-->  ind = [1,1,..,1]
  // Then count upwards: i -> i+1 corresponds to increasing
  // last entry in ind by 1. Reset indices modulo n[j] and
  // handle overflows:
  //-------------------------

  N:= _mult(n[j] $ j=1..d); // = nops(values)
  ind:= [1 $ d]: // op(values, i) = values[ind[1],..,ind[d]]
  result:= _mult(L[j,1] $ j=1..d)*op(values,1);
  for i from 2 to N do
      ind[d]:= ind[d] +1:
      for j from d downto 2 do
         if ind[j]>n[j] 
         then // overflow, reset index j modulo n[j],
              // increase preceding index by 1:
              ind[j]:= 1; ind[j-1]:= ind[j-1] + 1;
         else break;
         end_if;
      end_for:
      result:= result+ _mult(L[j,ind[j]] $ j=1..d)*op(values,i);
  end_for:

  result;

end_proc:

//----  end of interpolate -------------------------------

// Here is Olli's old code for 2d Interpolation:
/*---------------------------------------
Lagrange interpolation (2 dimensional)
Input:
    * m by n rectangular grid
    * x[i] <> x[j] ; i,j = 1,...,m ; i<>j ;
    * y[i] <> y[j] ; i,j = 1,...,n ; i<>j ;
    * z[i][j] = f(x[i], y[j]) ; i = 1,...,m , j = 1,...,n

    Output:
                m   n
               --- ---
    P(x, y) =  \   \    X(x,i) * Y(y,j) * z[i][j]
               /   /
               --- ---
               i=1 j=1

               m                            n
              ---    x  - x[k]             ---    y  - y[k]
    X(x,i) =  | |  -----------   Y(y,j) =  | |  -----------
              | |  x[i] - x[k]             | |  y[j] - y[k]
              k=1                          k=1
              k<>i                         k<>j

    degree(P, x) < m , degree(P, y) < n

    >> numeric::lagrange2d([[1,2,4],[3,5]], [[5,10],[24,-3],[6,5]], [x,y], Expr);


         /                              2       2                   \
         | 325 x   67 y   77 x y   191 x    15 x  y                 |
     poly| ----- + ---- - ------ - ------ + ------- - 799/6, [x, y] |
         \   2      2       2        6         2                    /

    >> n:= 2: xList:= [i $ i=1..n]:
    >> m:= 2: yList:= [j $ j=1..m]:
    >> fList:= [[1/(i+j)$j=1..m]$i=1..n]:
    >> numeric::lagrange2d([xList,yList],fList, [x,y], Expr)

     poly(1/12 x y + (-1/4) x + (-1/4) y + 11/12, [x, y])
--*/

/* ----------

numeric::lagrange2d := proc(xList, fList, vars)
   local F, i, j, k, m, n, L, x, xp, Y, y, yp, zp;
begin
   if args(0) = 4 then F:= args(4) else F:= hold(Expr) end_if;
   // still missing: apply F to data, if necessary
   xp := xList[1]; yp := xList[2]; zp := fList;
   m := nops(xp); n := nops(yp); x := vars[1]; y := vars[2];

   // Walter's code with total costs m^2+n^2+2*m*n = (m+n)^2 
   L:= [_mult((x-xp[k])/(xp[i]-xp[k])$k=1..i-1) *
        _mult((x-xp[k])/(xp[i]-xp[k])$k=i+1..m) $ i=1..m]:
   Y:= [_mult((y-yp[k])/(yp[j]-yp[k])$k=1..j-1) *
        _mult((y-yp[k])/(yp[j]-yp[k])$k=j+1..n) $ j=1..n]:
   _plus(_plus(
         mapcoeffs(poly(L[i],[x,y],F)*poly(Y[j],[x,y],F),_mult,zp[i][j])
               $ j=1..n ) $ i=1..m);

  // Olli's original code with higher costs m*n*(m+n)
  // poly(_plus(
  //        _plus(
  //          _mult((x-xp[k])/(xp[i]-xp[k])$k=1..i-1) *
  //          _mult((x-xp[k])/(xp[i]-xp[k])$k=i+1..m) *
  //          _mult((y-yp[k])/(yp[j]-yp[k])$k=1..j-1) *
  //          _mult((y-yp[k])/(yp[j]-yp[k])$k=j+1..n) *
  //          zp[i][j] $ j = 1 .. n
  //       ) $ i = 1 .. m
  //     ), [x,y], F)
end_proc:
----------*/
// end of file 
