//    

// kg, 20/07/95 

/*++
irreducible -- test if polynomial is irreducible

irreducible(p)

p - univariate polynomial over finite field or polynomial accepted by 'factor'
++*/

irreducible:=
proc(p)
  local T;
begin
  if args(0) <> 1 then
    error("wrong no of args")
  end_if;
  T:= domtype(p);
  if T::irreducible <> FAIL then
    return(T::irreducible(p))
  end_if;

  // call tests directly for univariate polynomials over finite fields
  if T = DOM_POLY then
    if nops(op(p,2)) = 1 then
      T:= op(p,3);
      if domtype(T) = DOM_DOMAIN then
        if T::hasProp = FAIL then
          return("unknown coeff. domain")
        end_if;
        if T::hasProp(Dom::GaloisField) or T::hasProp(Dom::IntegerMod) then
          return(faclib::is_irred_gf(p))
        elif T::hasProp(Dom::AlgebraicExtension) then
          return(faclib::algfactor(p,FALSE))
        end_if;
      elif T <> hold(Expr) then
        if not isprime(op(T)) then
          error("not a field")
        end_if;
        return(faclib::is_irred_gf(p))
      end_if
    end_if;
  end_if;

  p:= factor(p);
  T:= nops(p);
  if T = 1 then
    FALSE
  else
    bool((T = 3) and (op(p, 3) = 1))
  end_if
end_proc:

// end of file 
