// Friedrich Schwarz 28.3.1994 

// rewritten. stefanw 10.12.2003

/*--
ithprime(i) - calculates the ith prime
i - natural number

ithprime extends the kernel function ithprime

--*/


alias(maxIndex = 1000000):

ithprime :=
proc(n)
  local p, i;
begin

  if args(0) <> 1 then
    error("expected one argument in function call")
  elif not testtype(n,Type::Numeric) then
    return(procname(args()))
  elif domtype(n) <> DOM_INT or n < 1 then
    error("argument must be a natural number")
  end_if;

  
  if n <= stdlib::ithprime(PrimeLimit) then
    // use kernel function 
    stdlib::ithprime(n)
  elif n <= maxIndex then
    userinfo(2, "Using table lookup plus search");
    if n < 500 then
      // this should occur rarely, since it assumes a really
      // small prime number table
      p := 0;
      for i from 1 to n do
        p := nextprime(p+1)
      end_for
    else 
      p := numlib::thePrimes[n div 500];
      for i from 1 to modp(n,500) do
        p := nextprime(p+2)
      end_for;
      p; 
    end_if
  elif n < maxIndex + 70000 then
    // a nextprime-search starting from maxIndex will probably be faster
    // than the mechanism involving stdlib::pi
    p:= numlib::thePrimes[-1]; // = ithprime(maxIndex)
    for i from maxIndex + 1 to n do
      p:= nextprime(p+2)
    end_for;
    p
  else
    // guess position
    p:= nextprime(floor(op(numeric::solve(Li(`#x`) - Li(`#x`^(1/2)) = n, `#x`),
                           1)));
    userinfo(2, "Guessing p = ".expr2text(p));
    i:= stdlib::pi(p);
    userinfo(2, "Real pi-value for guess is ".expr2text(i));
    if i<=n then
      while i < n do
        i:=i+1;
        p:= nextprime(p+2)
      end_while
    else
      assert(i > n);
      while i > n do
        i:= i-1;
        p:= prevprime(p-2)
      end_while
    end_if;
    p        
  end_if;
end_proc:


// special case, may be done during initialization since the size of the
// internal prime number table won`t change thereafter
ithprime(PrimeLimit) := stdlib::ithprime(PrimeLimit):
