/*++
lcm -- compute the lcm of polynomials or expressions

lcm(poly,...)
lcm(expr,...)

poly - polynomials
expr - polynomial expressions

lcm computes the lcm of polynomials or expressions.
++*/

lcm:=
proc()
  local j, l, g, exact;
begin
  if args(0) = 0 then
    return(1)
  end_if;

  // try to overload
  for g in [ args() ] do
    if g::dom::lcm <> FAIL then
      return(g::dom::lcm(args()))
    end_if;
  end_for;

  if args(0) = 1 then
    return(gcd(args(1)))
  end_if;

  l:= args(1);
  for j from 2 to args(0) do
    g:= gcd(l, args(j));
    if g = FAIL then
      return(FAIL)
    end_if;
    if iszero(g) then
      return(g)
    end_if;
    case domtype(g)
      of DOM_POLY do
        exact := if nops(op(g, 2)) = 1 then Quo else Exact end_if;
        if length(l) < length(args(j)) then
          l := divide(l, g, exact) * args(j);
        else
          l := l * divide(args(j), g, exact);
        end_if;
        break;
      of DOM_INT do
      of DOM_RAT do
        l:= expand((l*args(j))/g);
        break;
      otherwise
        // l:= divide(l*args(j), g, Exact);
        l:= normal(l*args(j) / g)
    end_case
  end_for;
  l
end_proc:

// end of file 
