/*
  lhs  -- left side of an equation or a range
	rhs  -- right side of an equation or a range
*/
lhs:= proc(e) begin
    if args(0) = 0 then error("no arguments given") end_if;
    if e::dom::lhs <> FAIL then return( e::dom::lhs(args()) )
    elif args(0) <> 1 or 
         not contains( {"_equal","_unequal", "_approx", "_less",
                "_leequal","_range", "_in"},
                type(e) ) 
    then
        error("expecting an equation")
    else
        return( op(e,1) )
    end_if
end_proc:

rhs:= proc(e) begin
    if args(0) = 0 then error("no arguments given") end_if;
    if e::dom::rhs <> FAIL then return( e::dom::rhs(args()) )
    elif args(0) <> 1 or 
         not contains( {"_equal","_unequal", "_approx", "_less",
                "_leequal","_range", "_in"},
                type(e) ) 
    then
        error("expecting an equation")
    else
        return( op(e,2) )
    end_if
end_proc:
