/*
stdlib::mapEvalChanges(e, F <, furtherargs>)

e - any object
F - any object

applies F to the operands of e, with re-evaluating e if F(x)<>x for some operand x; but without re-evaluating the operands another time

*/

stdlib::mapEvalChanges:=
proc(e, F)
  local i;
begin
  subs(e, select([op(e, i) = F(op(e, i), args(3..args(0))) $i=1..nops(e)], _not@bool), EvalChanges)
end_proc:
