/*
maprat(e, f, options)

rationalizes e, then applies f, then substitutes back

e - any object that can be plugged into rationalize, or a sequence
f - any object that can be applied as a function
options - the same options as for rationalize are permitted

*/

maprat :=
proc(e)
  // we have to use option hold to handle sequences in the first argument
  option hold; 
  local f, argv, spec, subst;

begin
if args(0)<2 then 
  error("missing arguments") 
end_if;
e:=context(e); 
argv:= [context(args(2..args(0)))];
f:= argv[1];
delete argv[1];
if (spec:=bool(nops([e])<>1)) then 
  // the first argument was a sequence. This is allowed
  e:=[e] 
end_if;

// argv may contain options, either in the old or in the new syntax

e:=rationalize(e, op(argv));
userinfo(3, "new expression is ", e[1]);

if type(e[2]) = DOM_LIST then // option Recursive; we must not do a parallel substitution
  subst:= op(e[2])
else
  subst:= e[2]
end_if;

if spec then
  subs(f(op(e[1])), subst)
else
  subs(f(e[1]), subst)
end_if

end_proc:

// end of file
