//    

// kg, 19/01/94 

/*++
numer -- the numerator of a rational expression

numer(x <,options>)

x - expression
options - the same options as for normal, except that List is not permitted
++*/

numer:=
proc(x)
  local optiontypes, options, normaloptions, tmp;
begin
  if args(0) = 0 then
    error("numer called without arguments")
  end_if;
  
  if x::dom::numer <> FAIL then
    return(x::dom::numer(args()))
  end_if;
  if testargs() then
    if not testtype(x, Type::Arithmetical) then
      error("no arithmetical expression")
    end_if;
  end_if;
  
  if args(0) >= 2 and type(args(2)) = DOM_TABLE then
    options:= args(2);
    optiontypes:= null();
  else
    // we accept the same options as normal, but not the option List
    options:= table(normal::defaultOptions, args(2..args(0)));
    optiontypes:= normal::optiontypes;
    delete options[List], optiontypes[List];
  end_if;

  tmp:= prog::getOptions(2, [args()], options, TRUE, optiontypes);
  if nops(tmp) = 0 then
     normaloptions:= null()
  else
     normaloptions:= tmp[1];
  end_if;
  
  normaloptions[List]:= TRUE;

  // main part (the former stdlib::numer of version 2.0)

  case type(x)
    of DOM_INT do
      x;
      break;
    of DOM_RAT do
      op(x,1);
      break;
    of DOM_COMPLEX do
      case domtype(op(x,1))
        of DOM_INT do
          case domtype(op(x,2))
            of DOM_INT do
              x;
              break;
            of DOM_RAT do
              op(x,1)*op(x,[2,2]) + I*op(x,[2,1]);
              break;
            otherwise
              x;
          end_case;
          break;
        of DOM_RAT do
          case domtype(op(x,2))
            of DOM_INT do
              op(x,[1,1]) + I*op(x,2)*op(x,[1,2]);
              break;
            of DOM_RAT do
              igcd(op(x,[1,2]), op(x,[2,2]));
              op(x,[1,1])*op(x,[2,2])/% +
              I*op(x,[2,1])*op(x,[1,2])/%;
              break;
            otherwise
              x;
          end_case;
          break;
        otherwise
          x;
      end_case;
      break;
    of "_mult" do
      map(x, numer, options);
      break;
    of "_power" do
      if domtype(op(x,2)) = DOM_INT then
        if op(x,2) > 0 then
          numer(op(x,1), options) ^ op(x,2)
        else
          denom(op(x,1), options) ^ (-op(x,2))
        end_if
      else
        normal(x, normaloptions)[1]
      end_if;
      break;
    otherwise
      normal(x, normaloptions)[1];
  end_case
end_proc:
