/*++ ---------------- package.mu ---------------------
- package("path",<Forced,Quiet>)
  inserts a new library package. This package should have the same
  hierarchically structure as mupad's library. In contrast to mupad's
  library where the domains paths are already defined in the file .mupadsysinit
  in a package library this file is called init.mu and needs to be located
  in the directory lib, e.g. for UNIX operating system the new library
  package mypack should have the following structure:
    mypack/lib/init.mu
    mypack/lib/LIBFILES/mypack.mu
    mypack/lib/MYPACK/ ...
  A library package can be placed everywhere in the filesystem and is called
  via the whole path (up to the package name) given as a string. If no option
  is given, information about the package is printed out by a info call at
  the first try for loading the package.
  This can be suppressed with the option Quiet. A package will be loaded only
  once. If the option Forced is given, the package is loaded new by every call.
                                                                             
++*/

package :=
proc(str:DOM_STRING) // str, options: Forced, Quiet
  option noDebug;
  local fid, readpath, libpath, status, opt, loaded, t, i, protect_;
  save PACKAGEPATH, protect;
begin
    protect_ := protect;
    sysassign(protect,
              proc()
                option hold;
              begin
                sysassign(stdlib::SYSPROTECTED,
                          stdlib::SYSPROTECTED union {args(1)});
                context(subsop(hold(`#y`(`#x`)), 1=args(), 0=protect_))
              end):
  
  // detect options
  opt:={args(2..args(0))};
  loaded:=TRUE;
  status:=FAIL;
  libpath:=FAIL;
  t:=0;

  if PACKAGEPATH = hold(PACKAGEPATH) then
     PACKAGEPATH := "";
  else
    PACKAGEPATH := "", PACKAGEPATH;
  end;
  for i in PACKAGEPATH do
    // test, if package exists
    if (fid:=fopen(i.str.stdlib::PathSep."lib.tar#init.mu")) <> FAIL then
      libpath:=i.str.stdlib::PathSep."lib.tar#";
    elif (fid:=fopen(i.str.stdlib::PathSep."lib".stdlib::PathSep."init.mu"))
         <> FAIL then
      libpath:=i.str.stdlib::PathSep."lib"
    else
      next;
    end_if;
    
    // package exists
    // test, if path already exists
    readpath:=  // NOTE! no test if readpath is valid!
    i.str.stdlib::PathSep."modules".stdlib::PathSep.sysname(hold(Arch));
    if not contains({LIBPATH},libpath.stdlib::PathSep) then
      LIBPATH:=libpath,LIBPATH;
      loaded:=FALSE;
    end_if;
    if not contains({READPATH},readpath) then
      if READPATH=hold(READPATH) then READPATH:=readpath
      else
        READPATH:=readpath,READPATH;
      end_if;
    end_if;
    
    // load package
    if not loaded or contains(opt,hold(Forced)) then
      t:=traperror((status:=stdlib::syseval(fread(fid, Plain, Quiet))));
      sysassign(package::_which[str], i.str);
      if loaded then
        warning("Package redefined");
      end_if;
    else // package already loaded
      if not contains(opt,hold(Quiet)) then 
         warning("Package already defined. For redefinition use option Forced");
      end_if;
      status:=null();
    end_if;
    fclose(fid);
    if t<>0 then lasterror() end_if;

    // a package was successfully loaded;
    // inform all clients about possible new templates defined in the package
//    Content::writeLayoutSetup();
    
    // return load status
    return(status)
  end_for;
end_proc:

package := funcenv(package):
package::print := "package":
package::interface := {"which"}:
package::_which := table():
package::which :=
  proc(str : DOM_STRING)
  begin
    if contains(package::_which, str) then
      package::_which[str]
    else
      FAIL
    end
  end:

prog::setCheckedProtectedAssignments( package, {hold(protect)}):
