//      

// kg, 13/05/93 

/*++
pathname -- create machine-dependent directory path name

pathname( [ Root,] s1,...,sn )

s1,...,sn - directory names (strings) or Identifier 'Up'

pathname creates a machine dependant directory path name from a list of
directory names. If the option 'Root' is used as first argument, the path
name will be absolute, otherwise it will be relative to the current
directory. If an argument is the Identifier 'Up' the string
'/../',  '\..\, or ';;' is added to the path.

To provide true machine independent directory naming the names of the
directories must follow some conventions:
- A name may not contain one of the characters '/', '\' or ':',
  because these characters are name delimiters.
- A name may not contain more than 8 characters (MS-DOS).

It is not possible to define a volume name for MS-DOS with 'pathname'.
The name will be relative to the current volume.

Examples:

pathname("linalg","convert")
    -> "linalg/convert/"	under UNIX
    -> "linalg\convert\"	under MS-DOS
    -> ":linalg:convert:"	under MacOS

pathname(Root,"linalg","convert")
    -> "/linalg/convert/"	under UNIX
    -> "\linalg\convert\"	under MS-DOS
    -> "linalg:convert:"	under MacOS
++*/

pathname:= proc()
    option noDebug;
    local path, delim, root, wd, dir, argi, up, i, sys;
begin
    if args(0) = 0 then error("no parameters") end_if;

    sys := sysname();

    case sys
    of "UNIX"  do delim:= "/";  root:= "/";  wd:= ""; up := "../"; break;
    of "MACOS" do delim:= ":";  root:= "";   wd:= ":"; up := ":"; break;
    of "MSDOS" do delim:= "\\"; root:= "\\"; wd:= "";  up := "..\\"; break;
    otherwise: error("unknown machine type");
    end_case;

    if args(1) = hold(Root) then
	path:= root;
	argi:= 2;
    else
	path:= wd;
	argi:= 1;
    end_if;

    for i from argi to args(0) do
	dir:= args(i);
	if domtype(dir) <> DOM_STRING then 
	   if dir <> hold(Up) then
	      error("not a string") 
	   else
	      if (args(1) = hold(Root) and i=2) then
		  error("illegal path");
              end_if;
	      path := path.up;
	   end_if;
	else
	   if strmatch(dir,"/") then error("name contains '/'") end_if;
	   if strmatch(dir,":") then error("name contains ':'") end_if;
	   if strmatch(dir,"\\\\") then error("name contains '\\'") end_if;
	   path:= path.dir.delim;
	end_if;
    end_for;

    path
end_proc:

// end of file 
