/*
powermod -- power modulus a number or polynomial

powermod(p, n, m)

p - integer or polynomial
n - integer
m - integer or univariate polynomial

powermod(p, n, m) returns p^n mod m where p and m may be integers or 
univariate polynomials.
*/

powermod:=
proc(p, n, m) 
begin
  if args(0) < 1 then
    error("no arguments given")
  elif p::dom::powermod <> FAIL then
    return(p::dom::powermod( args() ))
  end_if;

  if args(0) <> 3 then
    error("wrong no of args")
  end_if;
  case domtype(m)
    of DOM_INT do
      if domtype(n) <> DOM_INT then
        error("no integer power")
      end_if;

      case domtype(p)
        of DOM_INT do
        of DOM_RAT do
          if n < 0 then
            return( stdlib::powermod(1/p, -n, m) )
          else
            return( stdlib::powermod(args()) )
          end_if
        of DOM_POLY do
          return( poly(poly(p, IntMod(m))^n, op(p,2..3)) )
        otherwise
          return( expr(poly(p, IntMod(m))^n) )
      end_case
    of DOM_POLY do
      if testargs() then
        if nops(op(m,2)) <> 1 then
          error("multivariate polynomials not allowed")
        elif domtype(n) <> DOM_INT then
          error("no integer power")
        end_if;
      end_if;

      if domtype(p) <> DOM_POLY then
        if p = FAIL then
          FAIL
        else
          expr(powermod(poly(p, op(m,2..3)), n, m))
        end_if
      elif op(p,2..3) = op(m,2..3) then
        case n
          of 0 do
            return(p^0);
          of 1 do
            return(divide(p, m, Rem));
        end_case;
        faclib::powermod_poly(args())
      elif op(p,3) = op(m,3) then
        poly(powermod(poly(p, op(m,2..3)), n, m),
             op(p,2..3))
      else
        error("polynomial types differ")
      end_if;
      break;
    of DOM_FAIL do
      return( FAIL )
    otherwise
      m:= poly(m);
      if testargs() then
        // check args here, because testargs()
        // will be false in the recursive call
        if type(m) <> DOM_POLY then
          error("Third argument cannot be converted into a polynomial")
        end_if;
        if type(n) <> DOM_INT then
          error("Second argument must be integer")
        end_if;
      end_if;
      return( powermod(p, n, m) )
  end_case
end_proc:

