/* from Decreasing the Nesting Depth of Expressions Involving Square Roots
   by Borodin, Fagin, Hopcroft and Tompa, JSC 1, 1985, pages 169-188 

  Other reference to consider:
  Landau,-Susan, How to tangle with a nested radical.  1994
  [The-Mathematical-Intelligencer] 16 (1994), no.  2, 49--55.
*/

alias(_radsimp_match2sqrt=stdlib::radsimp_match2sqrt,
        _radsimp_matchsqrt=stdlib::radsimp_matchsqrt,
	radnormal=stdlib::radnormal,
	_radsimp_matchmultsqrt=stdlib::radsimp_matchmultsqrt,
	_radsimp_sqrtdepth=stdlib::radsimp_sqrtdepth,
	_radsimp_rtdepth=stdlib::radsimp_rtdepth,
	_radsimp_ergaenzung1=stdlib::radsimp_ergaenzung1):



radsimp := 
proc(e)
  local q,abr,a,b,r,l,ee;
begin
  
  if args(0) = 0 then 
    error("radsimp called without arguments")
  end_if;
  
  // overloading
  if e::dom::radsimp <> FAIL then 
    return( e::dom::radsimp(args()) ) 
  end_if;
  
  if domtype(e)=DOM_EXPR 
    and not testtype(e, Type::AlgebraicConstant) then 
    //  e:= radnormal(e)
    if type(e)="_plus" then 
      e:= map(e, radsimp)
    elif contains({"_mult","_power"},type((e:=map(e,radsimp)))) then
      l:=[e]; ee:=0;
      repeat
             e:=l[1]; 
             delete l[1];
             if type((q:=denom(e)))="_plus" and
                (abr:=_radsimp_match2sqrt(q))<>FAIL then // q = a+b*sqrt(r) 
               a:=abr[1]; b:=abr[2]; r:=abr[3];
               e:=expand(numer(e)*(a-b*sqrt(r)))/(a^2-b^2*r);
               if testtype(e,Type::Constant) then 
                 e:=radnormal(e) 
               end_if;
               l:=append(l,(if type(e)="_plus" then op(e) else e end_if));
             else
               ee:=ee+e
             end_if;
      until l=[] end_repeat;
      e:=ee;
      if testtype(e, Type::AlgebraicConstant) then
        e:=radnormal(e)
      end_if;
    end_if;
  end_if;
  
  if testtype(e, Type::AlgebraicConstant) then          
    e:= radnormal(e)
  end_if;

  
  stdlib::radfactor(e)
end_proc:

radsimp := prog::remember(radsimp):

DOM_SET::radsimp:=proc() begin map(args(1),radsimp) end_proc :
DOM_LIST::radsimp:=proc() begin map(args(1),radsimp) end_proc :


_radsimp_ergaenzung1 := proc(e) //new
// 9/23/2001  dellaere 
// see Jeffrey, Rich: Simplifying Square Roots of Square Roots by Denesting
// Landau,-Susan, How to tangle with a nested radical.  1994

local f, l, n, j, x, y, k, X, Y, T, P, Q;
begin
  f := _radsimp_matchsqrt(e):
      if type(f) = "_plus"        //input of the form sqrt(A + B)
      then l := [op(f)]:
      	   n := _radsimp_rtdepth(f):
           j := ceil(nops(l)/2):         // splitpoint of sum
           x := _plus(l[k] $k = 1..j):
           y := _plus(l[k] $k = (j + 1)..nops(l)):
	   if Im(x) <> 0 or Im(y) <> 0 then return(e) end_if:
           if float(x) > float(y) 
           then X := x :  Y := y
           else Y := x :  X := y
           end_if:
           T := (X^2) - (Y^2):
           if _radsimp_rtdepth(T) >= n - 1 then return(e) end_if:
           P := simplify(X + sqrt(T)):
           if _radsimp_rtdepth(P) >= n then return(e) end_if:
           Q := simplify(X - sqrt(T)):
           if _radsimp_rtdepth(Q) >= n then return(e) end_if:
           return(radsimp(sqrt(radsimp(P)/2)) + sign(Y)*radsimp(sqrt(radsimp(Q)/2))):
      end_if:
      return(e):
end_proc:

_radsimp_rtdepth := proc(e) // 9/23/2001  dellaere 
// only used for _radsimp_ergaenzung1

local i;
option remember;
begin
   if _radsimp_matchsqrt(e)<>FAIL then 1 + _radsimp_rtdepth(op(e,1))
   elif type(e)="_power" then
      if type(op(e,2))=DOM_RAT then 1 + _radsimp_rtdepth(op(e,1))
      else 1
      end_if
   elif type(e)="_mult" then max(_radsimp_rtdepth(op(e,i))$i=1..nops(e))
   elif type(e)="_plus" then _plus(_radsimp_rtdepth(op(e,i))$i=1..nops(e))
   else 1
   end_if
end_proc:

_radsimp_match2sqrt := proc(f) // match a+b*sqrt(r) and returns a,b,r 
local a,b,i,j,br;
begin
    if type(f)="_plus" then
      b:=op(f,1); j:=1;
      for i from 2 to nops(f) do
         if _radsimp_sqrtdepth(op(f,i))>_radsimp_sqrtdepth(b) then b:=op(f,i); j:=i end_if
      end_for;
      // a:=f-b; 
      a:=subsop(f, j=null());
      f:=b;
      // f should be b*sqrt(r) 
      if (br:=_radsimp_matchmultsqrt(f))<>FAIL then return(a,br) end_if
    end_if;
    FAIL
end_proc:

_radsimp_matchsqrt := proc(e) // matches sqrt(f) and returns f, or FAIL 
begin
   if type(e)="_power" then
      if op(e,2)=1/2 then return(op(e,1)) end_if
   elif type(e)="sqrt" then return(op(e))
   end_if;
   FAIL
end_proc:

// matches b*sqrt(r) and returns b,r (b can be 1 or a product of several expressions) 
_radsimp_matchmultsqrt := proc(e) 
local r,t,f,b;
begin
   if type(e)="_mult" then
      b:=1; r:=1;
      for t in e do
         if (f:=_radsimp_matchsqrt(t))<>FAIL then r:=r*f else b:=b*t end_if
      end_for;
      if r<>1 then return(b,r) end_if
   elif (r:=_radsimp_matchsqrt(e))<>FAIL then return(1,r)
   elif type(e)="_power" then
      if type(op(e,2))=DOM_RAT and type(2*op(e,2))=DOM_INT then
         return(op(e,1)^(op(e,2)-1/2),op(e,1))
      end_if
   end_if;
   FAIL
end_proc:

_radsimp_sqrtdepth := proc(e)
local i;
option remember;
begin
   if _radsimp_matchsqrt(e)<>FAIL then 1+_radsimp_sqrtdepth(op(e,1))
   elif type(e)="_power" then
      if type(op(e,2))=DOM_RAT and type(2*op(e,2))=DOM_INT then 1+_radsimp_sqrtdepth(op(e,1))
      else 0
      end_if
   elif contains({"_plus","_mult"},type(e)) then max(_radsimp_sqrtdepth(op(e,i))$i=1..nops(e))
   else 0
   end_if
end_proc:

radnormal:=
proc(e)
  local l,s,Q,a,b,p,i,j,f,X,y,eq;
begin
  a:= normal(e, List);
  if a[2]<>1 then
    a:= radnormal(a[1]);
    if a=0 then
      return(0)
    end_if
  end_if;
  

  if contains({"_mult","_power","_plus"}, type(e)) then 
    e:=map(e, _radsimp_ergaenzung1) 
  end_if:
  e:=_radsimp_ergaenzung1(e);//new

  // use the "usual" simplification first
  e:= simplify(e);  

  l:=rationalize(e, FindRelations = ["_power"],Recursive);
  s:=l[2]; y:=null();
  Q:=Dom::Rational;
  for j from nops(s) downto 1 do
    eq:=s[j];
    X:=op(eq,1); a:=op(eq,2);
    if a=I then
      userinfo(20, "Substituted I by ".expr2text(op(eq,1)));
      b:=1/2;
      a:=-1
    elif type(a)<>"_power" then
      userinfo(5, "Found irrational subexpression ".expr2text(a).
               "; this one is not a power");
      // do not simplify the expression at all 
      return(e)
    else
      userinfo(20, "Substituted ".expr2text(a)." by ".expr2text(X));
      b:=op(a,2);
      if type(b)<>DOM_RAT then
        userinfo(20, "Found irrational exponent");
        return(e)
      end_if;
      a:=subs(op(a,1),y)
    end_if;
    f:=poly(X^denom(b)-(if b<0 then
                          expr(_invert(Q(a)))
                        else
                          a
                        end_if)^abs(numer(b)),
            [X],Q);
    userinfo(20, "Minimal polynomial is irreducible factor of ".expr2text(f));
    p:=f; f:=coerce(factor(f), DOM_LIST);
    if nops(f)>3 then // find good factor 
      userinfo(20, expr2text(nops(f) div 2)." irreducible factors found");
      a:=1;
      for i from 2 to nops(f) step 2 do
        userinfo(20, "Investigating irreducible factor ".expr2text(f[i]));
        userinfo(20, "Floating point approx. is ".
                 expr2text(float(subs(expr(f[i]),op(s)) )));
        b:=abs(float(subs(expr(f[i]),op(s))));
        if b<a then
          a:=b;
          p:=f[i]
        end_if
      end_for;
      userinfo(20, "Right choice for minimal polynomial is ".expr2text(p));
      userinfo(1,subs(op(eq,2),op(l[2])),"simplifies to",
               subs(expr(p),op(l[2])));  // do not write hold(X)
    else
      userinfo(5, "Polynomial is irreducible ");
      p:=f[2]
    end_if;
    if degree(p)>1 then
      Q:=Dom::AlgebraicExtension(Q,p);
      userinfo(20, "New extension field used is ".expr2text(Q))
    else
      userinfo(20, "Since the polynomial has degree 1, no field extension ".
               "is necessary");
      userinfo(20, "Field is still ".expr2text(Q));
      y:=y,X=-expr(coeff(p,0)/coeff(p,1));
      l[1]:=subs(l[1],y);
      userinfo(20,"Substituting ".expr2text({y})." gives ".expr2text(l[1]));
    end_if;
  end_for;
  expand(subs(expr(Q(numer(l[1]))*Q(denom(l[1]))^(-1)),op(l[2])))
end_proc:



// stdlib::radfactor - factors fractional integer powers 
//                     in expressions 

stdlib::radfactor:=
  proc(e)
  begin
    misc::maprec(e, 
                 {"_power"} = 
                 proc(pow)
                   local n, /* i, */ l;
                 begin
                   n:= op(pow, 1);
                   case type(n)
                       // we do not like 6^(1/2) -> 2^(1/2)*3^(1/2)
                       // any more
                       /*
                     of DOM_INT do
                       n:= ifactor(n, UsePrimeTab);
                       n[1]^op(pow, 2) * _mult(n[2*i]^(n[2*i+1] * op(pow, 2))
                                               $i=1..nops(n) div 2);
                       break
                       */
                     of "_mult" do
                       // extract positive factors
                       l:= split([op(n)], is, Type::Positive);
                       _mult(op(map(l[1], _power, op(pow, 2)))) *
                       _mult(op(l[2]), op(l[3]))^op(pow, 2);
                       break                       
                     of "_power" do
                       // apply (a^b)^c = a^(b*c) if possible, i.e.,
                       // if a > 0 and b,c are real
                       if (is(op(pow, 2), Type::Real) = TRUE or
                         is(op(n, 2), Type::Real) = TRUE)
                         and is(op(n, 1) >= 0) = TRUE then
                         return(op(n, 1)^(op(n, 2)*op(pow, 2)))
                       end_if;
                       // else fall through
                     otherwise
                       pow
                   end_case
                 end_proc
                )
    
  end_proc:


