
/*++
read -- read file

read(name, [ option_1, [ option_2 ] ] )
read(fd, [ option_1, [ option_2 ] ] )

name     - file name (string)
fd       - file descriptor (integer)
option_1 - option Plain or Quit
option_2 - option Plain or Quit
++*/

read:= proc(fd)
    option escape, noDebug;
    local f, p, isf;
    save LEVEL;
begin
    LEVEL := context(hold(LEVEL));
    if args(0) < 1 or args(0) > 3 then error("Wrong no of args") end_if;
    case domtype(fd)
    of DOM_INT do
       return(fread(fd));
    of DOM_STRING do
	if fd = "" then
	    if sysname() = "MACOS" then
	        return(fread(""))
	    end_if
	end_if;
	break;
    otherwise error("Illegal argument");
    end_case;

    if args(0) <> 1 then
       if {args(2..args(0))} minus {Plain,Quiet} <> {} then
          error("Illegal argument")
       end_if
    end_if;

    isf:= bool(fd[1] <> stdlib::PathSep);
    // try to open with READPATH
    if domtype(READPATH) <> DOM_IDENT then
        for p in READPATH do
	    if isf then
	        if p[-1] <> stdlib::PathSep then
		    p:= p.stdlib::PathSep
	        end_if
            end_if;
            f:= fopen(p.fd);
	    if f <> FAIL then
                p:= fread(f, args(2..args(0)));
                fclose(f);
                return(p)
            end_if
        end_for;
    end_if;

    // try to open with direct path
    f:= fopen(fd);
    if f <> FAIL then
        p:= fread(f, args(2..args(0)));
        fclose(f);
        return(p)
    end_if;

    // try to open with LIBPATH
    for p in LIBPATH do
        if isf then
	    if p[-1] <> stdlib::PathSep then
	        p:= p.stdlib::PathSep
	    end_if
        end_if;
        f:= fopen(p.fd);
        if f <> FAIL then
            p:= fread(f, args(2..args(0)));
            fclose(f);
            return(p)
        end_if
    end_for;

    error("Could not open \"".fd."\"");
end_proc:

