
/*++
readbytes -- read binary data from a file.

readbytes(filename <, m> <, format> <, byteorder>)
readbytes(n <, m> <, format> <, byteorder>)

filename  - file name (string)
n         - file descriptor (integer)
m         - The number of values to read (integer)
format    - either Byte, SignedByte, Short, SignedShort, Word, 
            SignedWord, Float or Double
            Default: Byte
byteorder - either BigEndian or LittleEndian. 
            Default: BigEndian
++*/

readbytes:= proc(fd)
    local f, p, isf;
begin
    if args(0) < 1 or args(0) > 4 then error("Wrong no of args") end_if;
    case domtype(fd)
    of DOM_INT do
	return(stdlib::readbytes(args()));
    of DOM_STRING do
	if fd = "" then
	    if sysname() = "MACOS" then
	        return(stdlib::readbytes(args()))
	    end_if
	end_if;
	break;
    otherwise error("Illegal argument");
    end_case;


    // at first try to open with direct path
    f:= fopen(fd, hold(Raw));
    if f <> FAIL then
        p:= stdlib::readbytes(f, args(2..args(0)));
        fclose(f);
        return(p)
    end_if;

    // otherwise try to open with READPATH
    isf:= bool(fd[1] <> stdlib::PathSep);
    if domtype(READPATH) <> DOM_IDENT then
        for p in READPATH do
    	    if isf then
    	        if p[-1] <> stdlib::PathSep then
    		        p:= p.stdlib::PathSep
    	        end_if
            end_if;
            f:= fopen(p.fd, hold(Raw));
    	    if f <> FAIL then
                p:= stdlib::readbytes(f, args(2..args(0)));
                fclose(f);
                return(p)
            end_if
        end_for;
    end_if;

    error("Could not open \"".fd."\"");
end_proc:

