/* ----------------------
remember -- add entries to a remember table

Calls: 

  remember(f(x1) = y1, f(x2) = y2)  

Parameters:
  f            -- an identifier or an indexed identifier
                  representing a procedure/function
  x1, x2, ...  -- whatever is accepted by f
  y1, y2, ...  -- arbitrary MuPAD objects

Return Value: the null() object

The remember table is filled as a side effect

-------------------------- */

remember:= proc(equation)
option hold;
begin
  if args(0) = 0 then 
     error("expecting at least one argument");
  end_if:
  if args(0) > 1 then
     context(hold(map)(hold(hold)([args()]), remember));
     return();
  end_if:
  if context(hold(type)(equation)) <> "_equal" then
     error("expecting an equation such as f(x) = y");
  end_if:
  context(hold(eval)(hold(subsop)(hold(hold)(equation), 0 = sysassign)));
  return():
end_proc:

