// mainly used for the reversion of Puiseux series 

revert :=
proc(x)
  // used in domains package initialisation
  option noDebug;
begin
  if x::dom::revert<>FAIL then
    return(x::dom::revert(x))
  end_if;
  procname(args())
end_proc:

// to revert strings, code from Ralf Hillebrand, 31 Oct 1996 
DOM_STRING::revert :=
  proc(str)
    local len, i;
  begin
    len := length(str);
    _concat(str[len-i+1] $ i = 1..len)
  end_proc:

// to revert lists, code from Ralf Hillebrand, 17 Feb 1997 
DOM_LIST::revert := 
  proc(list)
    // used in domains package initialisation
    option noDebug;
    local len, i;
  begin
    len := nops(list) + 1;
    [op(list, len-i) $ i=1..len-1]
  end_proc:

DOM_TABLE::revert :=
  proc(tbl)
  begin
    if nops(tbl) > 1 then
       table(map(op(tbl), e -> op(e,2)=op(e,1)));
    elif nops(tbl) = 1 then
       table( op(tbl, [1, 2]) = op(tbl, [1, 1]) );
    else // nops(tbl) = 0
       tbl;
    end_if:
  end_proc:

/*
   Let f be a polynomial in x1, .., xk of degree n_i in x_i.
   Its reverse is defined as \prod_i x_i^(n_i) * f(1/x_1, ..., 1/x_n).
   In other words, we have to replace every (x_i)^m by x_i^(n_i - m).
*/

DOM_POLY::revert:=
proc(f)
  local i, xlist, l: DOM_LIST, n: DOM_INT, nlist: DOM_LIST;
begin
  xlist:= op(f, 2);
  l:= poly2list(f);
  if nops(xlist) = 1 then
    n:= degree(f);
    //l = [[a_n, n], ..., [a_0, 0]], with zero terms missing
    l:= map(l, term -> [term[1], n -term[2]])
  else
    nlist:= [degree(f, xlist[i]) $i=1..nops(xlist)];
    l:= map(l, term -> [term[1], [nlist[i]-op(term, [2,i]) $i=1..nops(nlist)]])
  end_if;
  poly(l, xlist)
end_proc:
