//   

// rewrite the expression f to type typ

rewrite :=
proc(f, typ)
begin

  if args(0) <> 2 then
    error("wrong number of arguments")
  end_if;

  if f::dom::rewrite <> FAIL then
    return(f::dom::rewrite( args() ))
  end_if;

  if domtype(typ)= DOM_FUNC_ENV and slot(typ, "rewrite")<>FAIL then
    return(slot(typ, "rewrite")(args()))
  end_if;

  case expr2text(typ)
    of "exp" do
      subs(f,
               [hold(_power)=
                proc(a, b)
                begin
                  if a=0 or testtype(b, Type::Constant) then
                    a^b
                  else
                    exp(b*ln(a))
                  end_if
                end_proc,
                hold(sin)   = (x -> 1/(2*I)*(exp(x*I)-exp(-x*I))),
                hold(cos)   = (x -> 1/2*(exp(x*I)+exp(-x*I))),
                hold(tan)   = (x -> -I*(exp(x*I)^2-1)/(exp(x*I)^2+1)),
                hold(cot)   = (x -> I*(exp(x*I)^2+1)/(exp(x*I)^2-1)),
                hold(sinh)  = (x -> 1/2*(exp(x)-exp(-x))),
                hold(cosh)  = (x -> 1/2*(exp(x)+exp(-x))),
                hold(tanh)  = (x -> (exp(x)^2-1)/(exp(x)^2+1)),
                hold(coth)  = (x -> (exp(x)^2+1)/(exp(x)^2-1)),
                hold(arcsin)= (x -> -I*ln(I*x+sqrt(1-x^2))),
                hold(arccos)= (x -> -I*ln(x+I*sqrt(1-x^2))),
                hold(arctan)= (x -> I/2*(ln(1-I*x)-ln(1+I*x))),
                hold(arccot) = (x -> I/2*(ln(1-I/x)-ln(1+I/x))),
                hold(arcsinh)= (x -> ln(x+sqrt(x^2+1))),
                hold(arccosh)= (x -> ln(x+sqrt(x^2-1))),
                hold(arctanh)= (x -> 1/2*(ln(1+x)-ln(1-x))),
                hold(arccoth)= (x -> 1/2*(ln(1+1/x)-ln(1-1/x))),
             // 2-argument version of arg is obsolete
             // hold(arg)    = ((x, y) -> -I*ln((x+I*y)/abs(x+I*y)))
                hold(arg)    = (z -> -I*ln(z/abs(z))),
                hold(dawson) = (x -> -I/2*sqrt(PI)*exp(-x^2)*erf(x*I))
               ], EvalChanges);
      break
    of "arg" do
      subs(f,   [ // ln(sign(x)) = I*arg(x)
                hold(ln) = (x -> if type(x) = "sign" then
                                      I*arg(op(x)) 
                                   else
                                      hold(ln)(x)
                                   end_if)
               ], EvalChanges); 
      break;
    of "erf" do
      subs(f, [
                hold(erfc)   = (x -> 1 - erf(x)),
                hold(erfi)   = (x -> -I*erf(I*x)),
                hold(dawson) = (x -> -I/2*sqrt(PI)*exp(-x^2)*erf(x*I))
               ], EvalChanges);
      break;
    of "erfc" do
      subs(f, [
                hold(erf)    = (x -> 1 - erfc(x)),
                hold(erfi)   = (x -> -I*(1- erfc(I*x))),
                hold(dawson) = (x -> -I/2*sqrt(PI)*exp(-x^2)*(1- erfc(x*I)))
               ], EvalChanges);
      break;
    of "erfi" do
      subs(f, [
                hold(erf)   = (x -> I*erfi(-I*x)),
                hold(erfc)   = (x -> 1-I*erfi(-I*x)),
                hold(dawson) = (x -> 1/2*sqrt(PI)*exp(-x^2)*erfi(x))
               ], EvalChanges);
      break;
    of "inverf" do
      subs(f, hold(inverfc)   = (x -> inverf(1-x)), EvalChanges);
      break;
    of "inverfc" do
      subs(f, hold(inverf)   = (x -> inverfc(1-x)), EvalChanges);
      break;
    of "tan" do
      subs(f, [
                hold(sin)  = (x ->  2*tan(x/2)     / (1+tan(x/2)^2) ),
                hold(cos)  = (x -> (1-tan(x/2)^2)  / (1+tan(x/2)^2) ),
                hold(cot)  = (x ->  1/tan(x) ),
             // hold(exp)  = (x -> (1-I*tan(I*x/2))^2
             //                                    / (1+tan(I*x/2)^2) ),
                hold(exp)  = (x -> (I+tan(I*x/2))  / (I-tan(I*x/2)) ),
                hold(sinh) = (x -> -I*2*tan(I*x/2) / (1+tan(I*x/2)^2) ),
                hold(cosh) = (x -> (1-tan(I*x/2)^2)/ (1+tan(I*x/2)^2) ),
                hold(tanh) = (x ->-I*tan(I*x) ),
                hold(coth) = (x -> I/tan(I*x) )
               ], EvalChanges);
      break
    of "tanh" do
      subs(f, [
                hold(sin)  = (x ->-2*I*tanh(I*x/2) /(1-tanh(I*x/2)^2) ),
                hold(cos)  = (x ->(1+tanh(I*x/2)^2)/(1-tanh(I*x/2)^2) ),
                hold(tan)  = (x ->-I*tanh(I*x) ),
                hold(cot)  = (x -> I/tanh(I*x) ),
             // hold(exp)  = (x -> (1+tanh(x/2))^2 /(1-tanh(x/2)^2) ),
                hold(exp)  = (x -> (1+tanh(x/2))   /(1-tanh(x/2)  ) ),
                hold(sinh) = (x -> 2*tanh(x/2)     /(1-tanh(x/2)^2) ),
                hold(cosh) = (x -> (1+tanh(x/2)^2) /(1-tanh(x/2)^2) ),
                hold(coth) = (x ->  1/tanh(x))
               ], EvalChanges);
      break
    of "cot" do
      subs(f, [
                hold(sin)  = (x ->   2*cot(x/2)   / (cot(x/2)^2+1) ),
                hold(cos)  = (x -> (cot(x/2)^2-1) / (cot(x/2)^2+1) ),
                hold(tan)  = (x -> 1/cot(x) ),
             // hold(exp)  = (x ->-(1+I*cot(I*x/2))^2/(1+cot(I*x/2)^2) ),
                hold(exp)  = (x -> (cot(I*x/2)-I)   / (cot(I*x/2)+I) ),
                hold(sinh) = (x -> -I*2*cot(I*x/2)  / (1+cot(I*x/2)^2) ),
                hold(cosh) = (x -> (cot(I*x/2)^2-1) / (1+cot(I*x/2)^2) ),
                hold(tanh) = (x ->-I/cot(I*x) ),
                hold(coth) = (x -> I*cot(I*x) )
               ], EvalChanges);
      break
    of "coth" do
      subs(f, [
                hold(sin)  = (x -> -2*I*coth(I*x/2) /(coth(I*x/2)^2-1) ),
                hold(cos)  = (x -> (1+coth(I*x/2)^2)/(coth(I*x/2)^2-1) ),
                hold(tan)  = (x -> -I/coth(I*x) ),
                hold(cot)  = (x ->  I*coth(I*x) ),
             // hold(exp)  = (x -> (1+coth(x/2))^2 / (coth(x/2)^2-1) ),
                hold(exp)  = (x -> (1+coth(x/2))   / (coth(x/2)  -1) ),
                hold(sinh) = (x ->    2*coth(x/2)  / (coth(x/2)^2-1) ),
                hold(cosh) = (x -> (coth(x/2)^2+1) / (coth(x/2)^2-1) ),
                hold(tanh) = (x -> 1/coth(x) )
               ], EvalChanges);
      break
    of "ln" do
      subs(f, [
                // formulae 4.4.26-4.4.31 in Abramowitz and Stegun
                hold(arcsin)=(x ->  -I*ln(I*x+sqrt(1-x^2))),
                hold(arccos)=(x ->  -I*ln(x+I*sqrt(1-x^2))),
                hold(arctan)=(x ->   I/2*(ln(1-I*x)-ln(1+I*x))),
                hold(arccot)=(x ->  I/2*(ln(1-I/x) - ln(1+I/x))),
                // formulae 4.6.20-4.6.25 in Abramowitz and Stegun
                hold(arcsinh)=(x -> ln(x+sqrt(x^2+1))),
                hold(arccosh)=(x -> ln(x+sqrt(x^2-1))),
                // both rewriting rules arctanh -> ln are valid
         //     hold(arctanh)=(x -> ln(sqrt(1+x))-ln(sqrt(1-x))),
                hold(arctanh)=(x -> 1/2*( ln(1+x)-ln(1-x))),
                // both rewriting rules arccoth -> ln are valid
         //     hold(arccoth)=(x -> ln(sqrt(1+1/x))-ln(sqrt(1-1/x))),
                hold(arccoth)=(x -> 1/2* (ln(1+1/x)-ln(1-1/x))),
         //  the following does not hold for z=0 !!!
             // hold(arg)    = ((x, y) -> -I*ln((x+I*y)/abs(x+I*y))),
                hold(arg)    = (x -> if args(0) = 1 then
                                       -I*ln(x/abs(x))
                                     else //arg(x,y) = arg(x + I*y) = -I*ln(sign(x+I*y)) 
                                       -I*ln(sign(args(1)) + I*args(2))
                                     end_if),
                hold(log)=((b, x) -> ln(x)/ln(b))
               ], EvalChanges);
      break
    of "lambertW" do
      subs(f, hold(wrightOmega)
                   = (x->lambertW(ceil((Im(x)-PI)/2/PI), exp(x))), EvalChanges);
      break;
    of "gamma" do
      subs(f, [
                hold(fact) = (n -> gamma(n+1)),
                hold(fact2) = (n -> gamma(n/2 + 1)*2^(((2*n+1 - (-1)^n))/4)
                    * PI^ (((-1)^n - 1)/4)),
                hold(binomial) = ((n,k) ->
                                  if domtype(n) = DOM_INT and n<0 then
                                    (-1)^k * gamma(k-n)/gamma(k+1)/gamma(-n)
                                  else
                                    gamma(n+1)/gamma(k+1)/gamma(n-k+1)
                                  end_if
                                    ),
                hold(pochhammer) = ((n, k) -> gamma(n + k)/gamma(n)),
                hold(beta) = ((x,y) -> gamma(x)*gamma(y)/gamma(x+y))
               ], EvalChanges);
      break
    of "fact" do
      misc::maprec(f,
                   {"gamma"} =
                   proc(g)
                     local x;
                   begin
                     x:= op(g, 1);
                     if is(x in Z_, Goal = TRUE) then
                       fact(x - 1)
                     elif is(x - 1/2 in Z_ and x>=0, Goal = TRUE) then
                       // Abramowitz/Stegun, 6.1.12
                       x:= x - 1/2;
                       sqrt(PI)*(2*x)!/x!/2^(2*x)
                     else
                       g
                     end_if
                   end_proc,
                   {"binomial"} =
                   proc(b)
                     local n, k;
                   begin
                     [n, k]:= [op(b)];
                     fact(n)/fact(k)/fact(n-k)
                   end_proc,
                   {"beta"} =
                   proc(bet)
                     local x, y;
                   begin
                     [x, y]:= [op(bet)];
                     fact(x - 1)*fact(y - 1)/fact(x + y - 1)
                   end_proc,
                   {"fact2"} =
                   proc(fct2)
                     local n;
                   begin
                     n:= op(fct2, 1);
                     if is(n, Type::Even) = TRUE then
                       (n/2)! * 2^(n/2)
                     elif is(n, Type::Odd) = TRUE then
                       n! / ((n-1)/2)! / 2^((n-1)/2)
                     else
                       fact2(n)
                     end_if
                   end_proc,
                   {"pochhammer"} =
                   proc(xk)
                     local x, k;
                   begin
                     [x, k]:= [op(xk)];
                     ((k + x - 1)!)/((x - 1)!)
                   end_proc
                   );
      break
    of "diff" do
      // we must map into subexpressions of type "function" to
      // catch subexpressions = D(...)(x1, x2, ...).
      // Do not map into subexpressions of type "D", because
      // D(...) cannot be rewritten into diff if the arguments
      // (x1, x2, ..) are not known
      misc::maprec(f, {"function"} = stdlib::D2diff);
      break
    of "D" do
      // it suffices to map into subexpressions of type "diff"
      // to rewrite  diff(f(x), x) -> D(f)(x)
      misc::maprec(f, {"diff"} = stdlib::diff2D);
      break
    of "sign" do
      misc::maprec(f,{"heaviside"}=
                   proc()
                   begin
                     (sign(op(args(1)))+1)/2
                   end_proc,
                   {"abs"}=  // abs(x) = x / sign(x)
                   proc()
                   begin
                     op(args(1), 1)/sign(op(args(1), 1))
                   end_proc,
                   {"arg"}= // arg(x) = -I*ln(sign(x))
                   proc()
                   begin
                     if nops(args(1)) = 1 then
                       -I*ln(sign(op(args(1), 1)))
                     else  //arg(x,y) = arg(x + I*y) = -I*ln(sign(x+I*y)) 
                       -I*ln(sign(op(args(1), 1) + I*op(args(1), 2)))
                     end_if;
                   end_proc);
      break
    of "heaviside" do
      misc::maprec(f,{"sign"}=
                   proc()
                   begin
                     2*heaviside(op(args(1)))-1
                   end_proc );
      break
    of "piecewise" do
      subs(f, [
                hold(sign)=
                proc(x)
                begin
                  if type(x)=piecewise then
                    piecewise([piecewise::extmap(x, z -> z>0), 1],
                               [piecewise::extmap(x,_less,0), -1],
                               [piecewise::extmap(x, _equal, 0), 0],
                               [piecewise::extmap(x, z-> not z in R_),
                                x/sqrt(Re(x)^2+Im(x)^2) ]
                               )
                  else
                    piecewise([x>0, 1],
                               [x<0, -1],
                               [x=0, 0],
                               [not x in R_, x/sqrt(Re(x)^2+Im(x)^2)]
                               )
                  end_if
                end_proc,
                hold(abs)=
                proc(x)
                begin
                  if type(x)=piecewise then
                    piecewise([piecewise::extmap(x, z -> z>=0), x],
                               [piecewise::extmap(x,_leequal,0), -x],
                               [piecewise::extmap(x, z-> not z in R_),
                                sqrt(Re(x)^2+Im(x)^2) ]
                               )
                  else
                    piecewise([x>=0, x],
                               [x<=0, -x],
                               [not x in R_, sqrt(Re(x)^2+Im(x)^2)]
                               )
                  end_if;
                end_proc,
                hold(heaviside)=
                proc(x)
                  begin
                  if type(x)=piecewise then
                    piecewise([piecewise::extmap(x, z->z>0), 1],
                              [piecewise::extmap(x,_equal, 0), heaviside(0)],
                              [piecewise::extmap(x,_less,0), 0]
                               )
                  else
                    piecewise([x>0, 1],
                              [x=0, heaviside(0)],
                              [x<0, 0]
                               )
                  end_if;
                end_proc,
                hold(kroneckerDelta)=
                    proc(x, y)
                    begin
                      piecewise([x=y, 1], [x<>y, 0])
                    end_proc,
                hold(max)=
                    proc()
                      local argv, i, j;
                    begin
                      argv:= [args()];
                      assert(not hastype(argv, piecewise));
                      piecewise(
                      [_and(argv[i] >= argv[j] $j=1..args(0)), argv[i]]
                      $i=1..args(0))
                    end_proc,
                hold(min)=
                    proc()
                      local argv, i, j;
                    begin
                    argv:= [args()];
                      assert(not hastype(argv, piecewise));
                      piecewise(
                      [_and(argv[i] <= argv[j] $j=1..args(0)), argv[i]]
                      $i=1..args(0))
                    end_proc
           ], EvalChanges);
      break
    of "besselJ" do
      misc::maprec(f,
                   {"besselI"} = proc() local v, z; begin
                     [v, z]:= [op(args(1))];
                     z^v/(I*z)^v*besselJ(v,I*z)
                   end_proc,
                   {"besselY"} = proc() local v, z; begin
                     [v, z]:= [op(args(1))];
                     if is(v in Z_) <> TRUE then
                       cos(v*PI)/sin(v*PI)*besselJ(v,z) - 1/sin(v*PI)*besselJ(-v, z)
                     else
                       args(1)
                     end_if;
                   end_proc,
                   {"besselK"} = proc() local v, z; begin
                     [v, z]:= [op(args(1))];
                     if is(v in Z_) <> TRUE then
                       PI/2/sin(v*PI)*(I*z)^v/z^v*besselJ(-v,I*z) 
                     - PI/2/sin(v*PI)*z^v/(I*z)^v*besselJ( v,I*z)
                     else
                       args(1)
                     end_if;
                   end_proc,
                   {"airyAi"} = proc() local z, n; begin
                     if nops(args(1)) = 1 then 
                        [z, n]:= [args(1), 0];
                     else
                        [z, n]:= [op(args(1))];
                     end_if;
                     if n = 0 then
                       1/3*((-z)^(3/2))^(1/3)*  besselJ(-1/3, 2/3*(-z)^(3/2)) 
                      -1/3/((-z)^(3/2))^(1/3)*z*besselJ( 1/3, 2/3*(-z)^(3/2));
                     elif n = 1 then
                      -1/3*((-z)^(3/2))^(2/3)*    besselJ(-2/3,2/3*(-z)^(3/2)) 
                      +1/3/((-z)^(3/2))^(2/3)*z^2*besselJ( 2/3,2/3*(-z)^(3/2));
                     else
                        args(1)
                     end_if;
                   end_proc,
                   {"airyBi"} = proc() local z, n; begin
                     if nops(args(1)) = 1 then 
                        [z, n]:= [args(1), 0];
                     else
                        [z, n]:= [op(args(1))];
                     end_if;
                     if n = 0 then
                       1/sqrt(3)/((-z)^(3/2))^(-1/3)*  besselJ(-1/3, 2/3*(-z)^(3/2)) 
                      +1/sqrt(3)/((-z)^(3/2))^( 1/3)*z*besselJ( 1/3, 2/3*(-z)^(3/2));
                     elif n = 1 then
                       1/sqrt(3)/((-z)^(3/2))^(-2/3)*    besselJ(-2/3, 2/3*(-z)^(3/2)) 
                      +1/sqrt(3)/((-z)^(3/2))^( 2/3)*z^2*besselJ( 2/3, 2/3*(-z)^(3/2));
                     else
                        args(1)
                     end_if;
                   end_proc
      );
      break;
    of "besselI" do
      misc::maprec(f,
                   {"besselJ"} = proc() local v, z; begin
                     [v, z]:= [op(args(1))];
                     z^v/(-I*z)^v*besselI(v,-I*z)
                   end_proc,
                   {"besselY"} = proc() local v, z; begin
                     [v, z]:= [op(args(1))];
                     if is(v in Z_) <> TRUE then
                       cos(v*PI)/sin(v*PI)*z^v/(I*z)^v*besselI(v,I*z)   
                     - 1/sin(v*PI)*(I*z)^v/z^v*besselI(-v, I*z)
                     else
                       args(1)
                     end_if;
                   end_proc,
                   {"besselK"} = proc() local v, z; begin
                     [v, z]:= [op(args(1))];
                     if is(v in Z_) <> TRUE then
                       PI/2/sin(v*PI)*besselI(-v,z) - PI/2/sin(v*PI)*besselI(v, z)
                     else
                       args(1)
                     end_if;
                   end_proc,
                   {"airyAi"} = proc() local z, n; begin
                     if nops(args(1)) = 1 then 
                        [z, n]:= [args(1), 0];
                     else
                        [z, n]:= [op(args(1))];
                     end_if;
                     if n = 0 then
                       1/3*   (z^(3/2))^(1/3)*besselI(-1/3, 2/3*z^(3/2)) 
                     - 1/3* z/(z^(3/2))^(1/3)*besselI( 1/3, 2/3*z^(3/2));
                     elif n = 1 then
                     - 1/3*    (z^(3/2))^(2/3)*besselI(-2/3, 2/3*z^(3/2)) 
                     + 1/3*z^2/(z^(3/2))^(2/3)*besselI( 2/3, 2/3*z^(3/2));
                     else
                        args(1)
                     end_if;
                   end_proc,
                   {"airyBi"} = proc() local z, n; begin
                     if nops(args(1)) = 1 then 
                        [z, n]:= [args(1), 0];
                     else
                        [z, n]:= [op(args(1))];
                     end_if;
                     if n = 0 then
                       1/sqrt(3)*  (z^(3/2))^(1/3)*besselI(-1/3, 2/3*z^(3/2)) 
                     + 1/sqrt(3)*z/(z^(3/2))^(1/3)*besselI( 1/3, 2/3*z^(3/2));
                     elif n = 1 then
                       1/sqrt(3)*    (z^(3/2))^(2/3)*besselI(-2/3, 2/3*z^(3/2)) 
                     + 1/sqrt(3)*z^2/(z^(3/2))^(2/3)*besselI( 2/3, 2/3*z^(3/2));
                     else
                        args(1)
                     end_if;
                   end_proc
      );
      break;
    of "hypergeom" do
      misc::maprec(f,
        {"meijerG"} = (() -> meijerG::toHypergeom(args(1))),
        {"kummerU"} = proc() local a, b, z; begin
                        [a, b, z]:= [op(args(1))];
                        if domtype(b) = DOM_INT then
                           return(args(1))  // gamma(1-b) or gamma(b-1) is singular
                        elif domtype(a-b+1) = DOM_INT and a-b+1 <=0 then
                           gamma(b-1)/gamma(a)*hypergeom([a-b+1,2-b],z) 
                        elif domtype(a) = DOM_INT and a <=0 then
                           gamma(1-b)/gamma(a-b+1)*hypergeom([a], [b], z)
                        else
                           gamma(1-b)/gamma(a-b+1)*hypergeom([a], [b], z)
                          +gamma(b-1)/gamma(a)*z^(1-b)*hypergeom([a-b+1],[2-b],z) 
                        end_if;
                   end_proc
      );
      break;
    of "max" do
      misc::maprec(f,
        {"min"} = (ex -> -max(op(map(ex, _negate)))),
        {"abs"} = (ex -> if is(op(ex), Type::Real) = TRUE then
                           max(op(ex), -op(ex))
                         else ex end_if));
      break;
    of "min" do
      misc::maprec(f,
        {"max"} = (ex -> -min(op(map(ex, _negate)))),
        {"abs"} = (ex -> if is(op(ex), Type::Real) = TRUE then
                           -min(op(ex), -op(ex))
                         else ex end_if));
      break;
    of "harmonic" do
      misc::maprec(f,
          {"psi"} =  (ex -> if nops(ex) = 1 then
                               harmonic(op(ex) - 1) - EULER
                            else
                               hold(psi)(op(ex))
                            end_if)); 
      break;
    of "psi" do
      misc::maprec(f,
          {"harmonic"} =  (ex -> psi(op(ex) + 1) + EULER)
         ); 
      break;
    of "sincos" do
      misc::maprec(f,
                   {"exp"}= proc() begin
                     cos(op(args(1),1)/I)+I*sin(op(args(1),1)/I)
                   end_proc,
                   {"tan"}= proc() begin
                     sin(op(args(1)))/cos(op(args(1)))
                   end_proc,
                   {"cot"}= proc() begin
                     cos(op(args(1)))/sin(op(args(1)))
                   end_proc,
                   {"sinh"}= proc() begin
                     -I*sin(I*op(args(1),1))
                   end_proc,
                   {"cosh"}= proc() begin
                     cos(I*op(args(1),1))
                   end_proc,
                   {"tanh"}= proc() begin
                     -I*sin(I*op(args(1),1))/cos(I*op(args(1),1))
                   end_proc,
                   {"coth"}= proc() begin
                     I*cos(I*op(args(1),1))/sin(I*op(args(1),1))
                   end_proc
                  );
      break
    of "sin" do
      f:= rewrite(f, sincos);
      f:= misc::maprec(f,
                       {"_power"} =
                       proc(pow)
                         local base, expo, z;
                       begin
                         if type((base:= op(pow, 1))) = "cos" and
                           type((expo:= op(pow, 2))) = DOM_INT then
                           z:= op(base, 1);
                           if expo >= 2 or expo <= -2 then
                             // cos(z)^(2n) = (cos(z)^2)^n
                             //             = (1-sin(z)^2)^n
                             return
                             (base^(expo mod 2) * (1 - sin(z)^2)^(expo div 2))
                           end_if
                       end_if;
                       pow
                       end_proc
                       );
      // replace remaining cos(x) by 1 - 2 * sin(x/2)^2
      subs(f, hold(cos) = (x -> 1 - 2 * sin(x/2)^2), EvalChanges );
      break
    of "cos" do
      f:= rewrite(f, sincos);
      f:= misc::maprec(f,
                   {"_power"} =
                   proc(pow)
                     local base, expo, z;
                   begin
                     if type((base:= op(pow, 1))) = "sin" and
                       type((expo:= op(pow, 2))) = DOM_INT then
                       z:= op(base, 1);
                       if expo >= 2 or expo <= -2 then
                         // sin(z)^(2n) = (sin(z)^2)^n
                         //             = (1-cos(z)^2)^n
                         return
                         (base^(expo mod 2) * (1 - cos(z)^2)^(expo div 2))
                       end_if
                     end_if;
                     pow
                   end_proc
                                            );
      eval(f);
      break
    of "arcsin" do
      subs(f,
                [
                 hold(arccos) = (x -> PI/2 - arcsin(x)),
                 hold(arctan) = (x -> signIm(I*x)*(PI/2 - arcsin(1/sqrt(1+x^2)))),
                 hold(arccot) = (x -> signIm(I/x)*PI/2 - signIm(I/sqrt(1+x^2))*arcsin(x/sqrt(1+x^2)))
                 ], EvalChanges);
      break
    of "arccos" do
      subs(f,
                [
                 hold(arcsin) = (x -> PI/2 - arccos(x)),
                 hold(arctan) = (x -> signIm(I*x)* arccos(1/sqrt(1+x^2))),
                 hold(arccot) = (x -> signIm(I/x)*arccos(sqrt(-x^2)/sqrt(-(1+x^2))))
                 ], EvalChanges
                );
      break
    of "arctan" do
      subs(f,
                [
                 hold(arcsin)  = (x -> 2*arctan(x/(1 + sqrt(1-x^2)))),
                 hold(arccos)  = (x -> PI/2 - 2*arctan(x/(1 + sqrt(1-x^2)))),
                 hold(arccot)  = (x -> arctan(1/x)),                   // OK except for x = 0
                 hold(arctanh) = (x -> -I*arctan(I*x))
                 ], EvalChanges
                );
      break
    of "arccot" do
      subs(f,
                [
                 hold(arcsin) = (x -> 2*arccot((1 + sqrt(1-x^2))/x)),
                 hold(arccos) = (x -> PI/2 - 2*arccot((1 + sqrt(1-x^2))/x)),
                 hold(arctan) = (x -> arccot(1/x))   // OK except for x = 0
                 ], EvalChanges
                );
      break
    of "sinhcosh" do
      subs(f, [
                hold(exp) =(x ->  cosh(x) + sinh(x) ),
                hold(tanh)=(x ->    sinh(x)/cosh(x) ),
                hold(coth)=(x ->    cosh(x)/sinh(x) ),
                hold(sin) =(x ->  I*sinh(x/I) ),
                hold(cos) =(x ->    cosh(x/I) ),
                hold(tan) =(x ->  I*sinh(x/I)/cosh(x/I) ),
                hold(cot) =(x -> -I*cosh(x/I)/sinh(x/I) )
                   ], EvalChanges);
      break
    of "sinh" do
      f:= rewrite(f, sinhcosh);
      f:= misc::maprec(f,
                       {"_power"} =
                       proc(pow)
                         local base, expo, z;
                       begin
                         if type((base:= op(pow, 1))) = "cosh" and
                           type((expo:= op(pow, 2))) = DOM_INT then
                           z:= op(base, 1);
                           if expo >= 2 or expo <= -2 then
                             // cosh(z)^(2n) = (cosh(z)^2)^n
                             //             = (1 + sinh(z)^2)^n
                             return
                             (base^(expo mod 2) * (1 + sinh(z)^2)^(expo div 2))
                           end_if
                       end_if;
                       pow
                       end_proc
                       );
      // cosh(x) = cosh(x/2)^2 + sinh(x/2)^2 = 1 + 2*sinh(x/2)^2
      subs(f, hold(cosh) = (x -> 1 + 2 * sinh(x/2)^2), EvalChanges);
      break
    of "cosh" do
      f:= rewrite(f, sinhcosh);
      misc::maprec(f,
                   {"_power"} =
                   proc(pow)
                     local base, expo, z;
                   begin
                     if type((base:= op(pow, 1))) = "sinh" and
                       type((expo:= op(pow, 2))) = DOM_INT then
                       z:= op(base, 1);
                       if expo >= 2 or expo <= -2 then
                         // sinh(z)^(2n) = (sinh(z)^2)^n
                         //             = (-1 + cosh(z)^2)^n
                         return
                         (base^(expo mod 2) * (-1 + cosh(z)^2)^(expo div 2))
                       end_if
                   end_if;
                   pow
                   end_proc
                   );
      break
    of "arcsinh" do
      subs(f,
                [
                 hold(ln)     = (x -> signIm(I*(x + 1/x))* arcsinh((x-1/x)/2)
                                    + PI*I*signIm(x)*(1 - signIm(I*(x+1/x)))/2),
                 hold(arcsin) = (x -> signIm(I*x)*(PI + 2*I*arcsinh(I/sqrt(2)*sqrt((1 - x^2)^(1/2) + 1)))),
                 hold(arccos) = (x -> (1/2 - signIm(I*x))*PI
                                          - signIm(I*x)*2*I*arcsinh(I/sqrt(2)*sqrt((1 - x^2)^(1/2) + 1))),
                 hold(arctan) = (x -> signIm(I*x)*(PI/2 + I*arcsinh(I/(x^2 + 1)^(1/2)))),
                 hold(arccot) = (x -> signIm(I/x)*(PI/2 + I*arcsinh(I/(1/x^2 + 1)^(1/2)))),
                 hold(arccosh) = (x -> signIm(I*x)*arcsinh(sqrt(x^2 - 1))
                                        + PI*I*signIm(x + sqrt(x^2 -1))*(1 - signIm(I*x))/2),
             //  both of the following formulas for arctanh --> arcsinh are ok
             //  hold(arctanh) = (x -> signIm(x)*(PI/2*I + signIm(x^2 - 1)* arcsinh(1/sqrt(x^2 - 1)))),
                 hold(arctanh) = (x -> signIm(x)*(PI/2*I - arcsinh(I/sqrt(1 - x^2)))),
             //  both of the following formulas for arccoth --> arcsinh are ok
             //  hold(arccoth) = (x -> signIm(1/x)*(PI/2*I + signIm(1/x^2 - 1)* arcsinh(1/sqrt(1/x^2 - 1)))),
                 hold(arccoth) = (x -> signIm(1/x)*(PI/2*I - arcsinh(I/sqrt(1 - 1/x^2))))
                ], EvalChanges
                );
      break
    of "arccosh" do
      subs(f,
                [hold(ln)     = (x -> signIm(I*(x - 1/x))* arccosh(1/2*(x + 1/x))
                                    + PI*I/2* (1 - sqrt(x)*sqrt(1/x))*(1 - signIm(I*(x-1/x)))),
                 hold(arcsin) = (x -> I*signIm(x)*arccosh(sqrt(1 - x^2))),
                 hold(arccos) = (x -> I*signIm(sqrt(1 - x^2))*arccosh(x)
                                    + (1 - sqrt(x+1)*sqrt(1/(x+1)))*PI),
                 hold(arctan) = (x -> signIm(I*x)*PI/2 - I*signIm(1/x)*arccosh(sqrt(x^2/(x^2 + 1)))),
                 hold(arccot) = (x -> signIm(I/x)*PI/2 - I*signIm(x)*arccosh(sqrt(1/(x^2 + 1)))),

                 hold(arcsinh) = (x -> signIm(I*x)*arccosh(sqrt(x^2 + 1))),
                 hold(arctanh) = (x -> signIm(x)*I*PI/2
                                     + signIm(I/x) * arccosh(sqrt(x^2/(x^2 - 1)))),
                 hold(arccoth) = (x -> signIm(1/x)*I*PI/2
                                     + signIm(I*x) * arccosh(sqrt(1/(1 - x^2))))
                 ], EvalChanges
                );
      break
    of "arctanh" do
      subs(f,
                [hold(ln)     = (x ->  2*arctanh((x-1)/(x+1))
                                     + PI*I*(1 - sqrt(x+1)*sqrt(1/(x + 1)))
                                ),       // OK except for x = -1
                 hold(arcsin) = (x -> -2*I*arctanh((I*x + (1-x^2)^(1/2) - 1)/
                                                   (I*x + (1-x^2)^(1/2) + 1))
                                ),       // OK except for x = I
                 hold(arccos) = (x -> PI/2 + 2*I*arctanh((I*x + (1-x^2)^(1/2) - 1)/
                                                         (I*x + (1-x^2)^(1/2) + 1))
                                ),       // OK except for x = I
                 hold(arctan) = (x -> -I*arctanh(I*x)),  // OK except for x = +- 1 , +-I
                 hold(arccot) = (x -> -I*arctanh(I/x)),  // OK except for x = +- 1 , +-I
              // both the following rules arcsinh -> arctanh are OK:
              // hold(arcsinh) = (x -> arctanh(sqrt(1 + x^2)/x) - PI/2*I*signIm(conjugate(x))):
                 hold(arcsinh) = (x -> 2*arctanh((x - 1 + (x^2 + 1)^(1/2))/
                                                 (x + 1 + (x^2 + 1)^(1/2)))) ,
                 hold(arccosh) = (x -> 2*arctanh((x - 1 + (x^2 - 1)^(1/2))/
                                                 (x + 1 + (x^2 - 1)^(1/2)))) ,
                 hold(arccoth) = (x -> arctanh(1/x))  // OK except for x = 0
                ], EvalChanges
                );
      break
    of "arccoth" do
      subs(f,
                [hold(ln)     = (x ->  2*arccoth((x+1)/(x-1))
                                     + PI*I*(1 - sqrt(x+1)*sqrt(1/(x + 1)))
                                ),       // OK except for x = 1
                 hold(arcsin) = (x -> -2*I*arccoth((I*x + (1-x^2)^(1/2) + 1)/
                                                   (I*x + (1-x^2)^(1/2) - 1))
                                ),       // OK except for x = 0
                 hold(arccos) = (x -> PI/2 + 2*I*arccoth((I*x + (1-x^2)^(1/2) + 1)/
                                                         (I*x + (1-x^2)^(1/2) - 1))
                                ),       // OK except for x = 0
                 hold(arctan) = (x -> I*arccoth(I/x)),  // OK except for x = +- 1 , +-I
                 hold(arccot) = (x -> I*arccoth(I*x)),  // OK except for x = +- 1 , +-I
              // both the following rules arcsinh -> arccoth are OK:
              // hold(arcsinh) = (x -> arccoth(1/sqrt(1 + x^2)/x) - PI/2*I*signIm(conjugate(1/x))):
                 hold(arcsinh) = (x -> 2*arccoth((x + 1 + (x^2 + 1)^(1/2))/
                                                 (x - 1 + (x^2 + 1)^(1/2)))) ,
                 hold(arccosh) = (x -> 2*arccoth((x + 1 + (x^2 - 1)^(1/2))/
                                                 (x - 1 + (x^2 - 1)^(1/2)))) ,
                 hold(arctanh) = (x -> arccoth(1/x))  // OK except for x = 0
                 ], EvalChanges
                );
      break
    of "bernoulli" do
      subs(f,
                [
                 hold(euler) = ((n, x) -> if args(0) = 1 then
                                            -2*(2^n - 1)/(n+1)*bernoulli(n+1)
                                            -4*2^(2*n)/(n+1)*bernoulli(n+1, 1/4)
                                          else
                                            2/(n+1)*bernoulli(n+1, x) 
                                          - 2^(n+2)/(n+1)*bernoulli(n+1, x/2) 
                                          end_if)
                ], EvalChanges);
      break
    of "andor" do
      misc::maprec(f,
                   {"_implies"} = (x -> not op(x,1) or op(x,2)),
                   {"_equiv"}   = (x -> op(x,1) and op(x,2) or
                                   (not op(x,1) and not op(x,2))),
                   {"_xor"}     = proc(x) begin
                                   if nops(x)=2 then
                                     (op(x,1) or op(x,2)) and
                                       not (op(x,1) and op(x,2))
                                   else
                                     rewrite(_xor((op(x,1) or op(x,2)) and
                                          not (op(x,1) and op(x,2)),
                                          op(x,3..nops(x))), andor);
                                   end_if;
                                  end_proc
                   );
      break
    of "Re" do
      subs(f, hold(Im) = (x -> (x - Re(x))/I ), EvalChanges);
      break
    of "Im" do
      subs(f, hold(Re) = (x -> (x - Im(x))), EvalChanges);
      break
    otherwise
      error("Unknown target type in rewrite")
  end_case;
end_proc:

//--------------------------------------------------
// utilities for rewrite target 'diff'
//--------------------------------------------------
/*
  Rewrite D(..)(x1, x2, ..) to diff(..., x1, x2, ...)
  if x1, x2, .. are distinct identifiers/indexed identifiers.

  If x1, x2, are not identifiers, then rewriting to D to diff
  would be possible. However, diff would reconvert to D automatically.

  If any of the identifier x1, x2,... occurs twice,
  D cannot be rewritten.
  E.g., D([1], f)(x1, x1) = diff(f(x1, x1), x1) - D([2], f)(x1, x1).

  The following is implemented:

  D(f)(x) -> diff(f(x),x)
  D(D(f))(x) -> diff(f(x),x,x)
  D([1],f)(x) -> diff(f(x),x)
  D([1,2],f)(x,y) -> diff(f(x,y),x,y)
  D(f)(x,y) -> error
*/
stdlib::D2diff:=
proc(x)
  local i, f, arglist, nlist, varlist;
begin
  if type(op(x, 0)) <> "D" then
     return(x);
  end_if;

  if nops(x)=1 and
     contains({DOM_IDENT, "_index"}, type(op(x,1))) and
     nops(op(x,0))=1
     then // x = D(f)(X)
          return(stdlib::recursiveD2diff(op(x, 0..1)))
  else
    // D(...)(X, Y, ...)
    arglist := [op(x)];

    if nops(op(x,0))=2 then
      // x = D([n1, n2,...], f)(X, Y, ...)
      // nlist = op(x, [0, 1]) = [n1, n2, ...]
      // op(x, [0, 2]) = f
      nlist:= op(x,[0,1]); // list of indices
      varlist:= [op(x, nlist[i]) $ i =1..nops(nlist)]:
      if has(varlist, FAIL) then
         error("derivative with respect to a non-existing ".
               "argument requested");
      end_if;
      for i from 1 to nops(nlist) do
        // check that the argument is a variable or indexed variable
        // and that this variable does not accour anywhere else --
        // D([1], f)(x, y, x) cannot be rewritten as a diff call
        if {type(varlist[i])} minus {DOM_IDENT, "_index"} <> {} or
          // Walter, 25.2.08: Beware: the following line
          //    has(subsop(arglist, nlist[i]=null()), [varlist[i]]) 
          // is not appropriate. Note: has(x[1], x) --> TRUE!
          contains(numeric::indets(subsop(arglist, nlist[i]=null())), varlist[i])
        then
          return(x);
        end_if;
      end_for;
      diff(subsop(x, 0 = op(x,[0,2])), op(varlist));
    elif
      nops(op(x,0))=1 and op(x,[0,0])=hold(D)
      then
         // x = D(f)(X1,X2,...,X.N) -> diff(f(X1,X2,...), X1)+diff(...,X2)+...
         if map({op(arglist)}, type) minus {DOM_IDENT, "_index"} <> {} or
           nops(arglist) > nops({op(arglist)}) then
           return(x);
         end_if;
         if nops(x) > 1 then
            error("univariate derivative ".expr2text(op(x, 0)).
                  " called with ".expr2text(nops(x)). " arguments (".expr2text(op(x)).")")
         end_if;
         // x = D(f)(X) -> diff(f(X), X)
         // op(x, [0, 1]) = f
         f:= op(x, [0, 1]);
         diff(f(op(x, 1)), op(x, 1));
    else x
    end_if
  end_if
end_proc:

// rewrite  D(D(..(D(f))..))(X) -> diff(f(X), X, .., X)
stdlib::recursiveD2diff:= proc()
begin
  if type(args(1))="D" and nops(args(1))=1 then
     //args() = D(D(..(D(f))..)), X
     diff(stdlib::recursiveD2diff(op(args(1),1),args(2)),args(2))
  else
    // stopping criterion for the recursive call:
    // recursiveD2diff(f, X) = f(X)
    args(1)(args(2))
  end_if
end_proc :

//--------------------------------------------------
// utilities for rewrite target 'D'
//--------------------------------------------------

// stdlib::diff2D: convert diffs in an expression into D's
//
// Applying the multivariate chain rule:
// diff(function(y1, y2, ...), x1, x2, x3, ...))
// -->
// diff(  diff(function(y1,y2,..),x1), x2, x3, ...)
// -->
// diff(  D([1], function)(y1, y2, ...) * diff(y1, x1)
//      + D([2], function)(y1, y2, ...) * diff(y2, x1)
//      + ...,
//      x2, x3, ...)
//
// and the diff's are converted into D's recursively

stdlib::diff2D :=
proc(f)
  local g, function, y, x1, otherVariables, i;
begin
   if not has(f, diff) then
     return(f);
   end_if;
   case type(f)
   of "_plus" do
   of "_mult" do
   of "_power" do
      // step recursively into expressions
      return(map(f, stdlib::diff2D))
   of "diff" do

      // apply multivariate chain rule and proceed recursively
      // f= diff(function(y1, y2, ...), x1, x2, ...)
      //         ^^^^^^^^^^^^^^^^^^^^^
      //                 g

      g:= op(f, 1):

      if domtype(g) <> DOM_EXPR then
         return(f);
      end_if;

      // now, do rewrite!
      function := op(g, 0);
      y := [op(g)];  // = [y1, y2, ..]
      x1 := op(f, 2);
      otherVariables := op(f, 3..nops(f));
      if nops(y) = 1 then
           return(stdlib::diff2D(
             diff(
                _plus( D(function)(op(y)) *
                       stdlib::diff2D(diff(y[i], x1))
                       $ i = 1..nops(y)
                     ),
             otherVariables)))
      else return(stdlib::diff2D(
             diff(
                _plus( D([i], function)(op(y)) *
                       stdlib::diff2D(diff(y[i], x1))
                       $ i = 1..nops(y)
                     ),
             otherVariables)))
      end_if;
   end_case;
   // default: do nothing
   f
end_proc:
