//    

// kg, 27/12/94 

/*++
setuserinfo -- set information level for procedure

setuserinfo(p [,lev])

p   - procedure, name of procedure, domain or 'Any'
lev - level of information (positive integer)

Sets the information level of the procedure or domain p to lev. If lev
is missing the level for p is set to 0.

If p is 'Any' then the global information level is set to lev
or to 0 resp.

See 'userinfo'.
++*/

setuserinfo:=
  proc(pnam = hold(Any), lev = 0, opt)
    option hold;
    local info_level;
  begin
    if testargs() then
      if args(0) > 3 then error("wrong no of args") end_if;
      if args(0) >= 2 then
        if domtype(context(lev)) <> DOM_INT then
          error("illegal level");
          if context(lev) < 0 then error("illegal level") end_if;
        end_if
      end_if;
      if args(0) = 3 and opt <> hold(Name) and opt <> hold(Quiet) then
        error("illegal option");
      end_if;
    end_if;
    
    // get proc name if argument is proc 
    if domtype(pnam) = DOM_PROC then
      pnam:= op(pnam, 6)
    end_if;
  
    // store level for proc 
    case args(0)
      of 0 do   info_level:= _userinfo_level();
                lev:= info_level;
		break;
      of 1 do   if domtype(args(1)) = DOM_NIL then 
		  info_level:= table();
                  lev:= table()
                elif domtype(context(args(1))) = DOM_INT then
		  info_level:= _userinfo_level();
                  if context(args(1)) = 0 then
                    delete info_level[hold(Any)];
                  else
                    info_level[hold(Any)]:= context(args(1));
                  end_if
                else 
		  info_level:= _userinfo_level();
		  if contains(info_level, pnam) then // Ruckgabewert
		    lev:= info_level[pnam];
                    if contains(info_level, (pnam, hold(Name))) then
                      lev:= lev, hold(Name)
                    end_if
		  end_if
                end_if;
		break;
      otherwise info_level:= _userinfo_level();
	        if domtype(context(lev)) = DOM_NIL then
		  delete info_level[pnam]
	        elif context(lev) = 0 then
                  info_level[pnam] := 0;
                  if pnam = hold(Any) then
                    delete info_level[pnam]
                  end_if
                else
                  if pnam = hold(All) then pnam:= hold(Any) end_if;
		  info_level[pnam]:= context(lev);
                  if args(args(0)) = hold(Name) then
                    info_level[pnam]:= context(lev), hold(Name)
                  elif args(args(0)) = hold(Quiet) then
                    info_level[pnam]:= context(lev), hold(Quiet)
                  end_if;
		  if contains(_userinfo_level(), pnam) then // Ruckgabewert
		    lev:= _userinfo_level()[pnam]
		  else
		    lev:= 0
		  end_if
		end_if
    end_case;
    _userinfo_level(info_level);
    lev
end_proc:

// end of file 
