// 

// The operator subset and its negation

_subset := funcenv
(proc(A, B)
   name _subset;
   local newA, a;
 begin
   if A = B then
     return(TRUE)
   end_if;

  if A::dom = DOM_SET then
     if B::dom = DOM_SET then
       // because subset is used also in a ,,technical'' sense,
       // we have to create a special case that is mathematically wrong
       // e.g. {a} may be a subset of {b}
       return(bool(A minus B = {}))
     end_if;
     newA:= [];
     for a in A do
       case is(a in B)
         of FALSE do
           return(FALSE)
         of UNKNOWN do
           newA:= newA.[a]
       end_case
     end_for;
     case nops(newA)
       of 0 do
         return(TRUE)
       of 1 do
         return(op(newA, 1) in B)
       otherwise
         return(procname({op(newA)}, B))
     end_case;
   end_if;

   if A::dom::_subset <> FAIL then
     a := A::dom::_subset(A, B);
     if type(a)<>"_subset" then return(a); end_if;
   end_if;
   if B::dom::_subset <> FAIL then
     a := B::dom::_subset(A, B);
     if type(a)<>"_subset" then return(a); end_if;
   end_if;
 
   procname(args())

 end_proc,
 builtin(1097, output::Priority::Relation, " subset ", "_subset")):

_subset::TeX :=
(arg1, arg2, arg3) -> (generate::TeXoperator(" \\subset ", arg3,
                                             output::Priority::Relation, op(arg2))):

_subset::Content := stdlib::genOutFunc("Csubset", 2):
_subset::_not := () -> _notsubset(args()):
_subset::type := "_subset":
_subset::print := "_subset":

// _prsubset := funcenv
// (proc(A, B)
//    name _prsubset;
//    local sub;
//  begin
//    if A::dom::_prsubset <> FAIL then
//      return(A::dom::_prsubset(A, B));
//    elif B::dom::_prsubset <> FAIL then
//      return(B::dom::_prsubset(A, B));
//    elif A = B then
//      return(FALSE);
//    else
//      sub := _subset(A, B);
//      if sub::dom = DOM_BOOL then
//        return(sub);
//      else
//        procname(args());
//      end_if
//    end_if
//  end_proc,
//  builtin(1097, output::Priority::Relation, " prsubset ", "_prsubset")):
//
// _prsubset::TeX :=
// (arg1, arg2, arg3) -> (generate::TeXoperator(" \\subsetneq ", arg3,
//                                              output::Priority::Relation, op(arg2))):
//
// _prsubset::Content := stdlib::genOutFunc("Cprsubset", 2):
// _prsubset::_not := () -> _notprsubset(args()):
// _prsubset::type := "_prsubset":
// _prsubset::print := "_prsubset":

_notsubset := funcenv
(proc(A, B)
   name _notsubset;
   local sub;
 begin
   sub := _subset(A, B);
   if type(sub) <> "_subset" then
     return(not sub)
   else
     procname(op(sub))
   end_if
 end_proc,
 ex -> hold(_not)(hold(_subset)(op(ex)))):

_notsubset::TeX :=
(arg1, arg2, arg3) -> (generate::TeXoperator(" \\not\\subset ", arg3,
                                             output::Priority::Relation, op(arg2))):

_notsubset::Content := stdlib::genOutFunc("Cnotsubset", 2):
_notsubset::expr2text := eq -> if nops(eq) = 2 then
                             "not ".expr2text(op(eq, 1))." subset ".expr2text(op(eq, 2))
                           else
                             "_notsubset(".expr2text(op(eq)).")"
                           end_if:
_notsubset::_not := () -> _subset(args()):
_notsubset::type := "_notsubset":
_notsubset::print := "_notsubset":

_notsubset::testtype:=
proc(x, T)
begin
  if T = Type::Set or T = Type::Arithmetical then
    FALSE
  else 
    FAIL
  end_if
end_proc:

// _notprsubset := funcenv
// (proc(A, B)
//    name _notprsubset;
//    local sub;
//  begin
//    sub := _prsubset(A, B);
//    if sub::dom = DOM_BOOL then
//      return(not sub);
//    else
//      procname(args());
//    end_if
//  end_proc,
//  ex -> hold(_not)(hold(_prsubset)(op(ex)))):
//
// _notprsubset::TeX :=
// (arg1, arg2, arg3) -> (generate::TeXoperator(" \\not\\subsetneq ", arg3,
//                                              output::Priority::Relation, op(arg2))):
//
// _notprsubset::Content := stdlib::genOutFunc("Cnotprsubset", 2):
// _notprsubset::expr2text := eq -> if nops(eq) = 2 then
//                             "not ".expr2text(op(eq, 1))." prsubset ".expr2text(op(eq, 2))
//                           else
//                             "_notprsubset(".expr2text(op(eq)).")"
//                           end_if:
// _notprsubset::_not := () -> _prsubset(args()):
// _notprsubset::type := "_notprsubset":
// _notprsubset::print := "_notprsubset":

