
/*++
undefined -- the undefined value
++*/

proc()
    option noDebug;
    local undef;
begin

undef:= newDomain("stdlib::Undefined");
undef::create_dom:=hold(stdlib::Undefined):
undefined:= new(undef);

undef::info:= "Domain 'stdlib::Undefined': representing an undefined value";
undef::interface:= {};

undef::expr:= proc() begin undefined end_proc:
undef::print:= proc() begin hold(undefined) end_proc:
undef::TeX:= proc() begin "\\text{undefined}" end_proc;
undef::func_call:= proc() begin undefined end_proc;
undef::testtype:= 
proc(x, T)
begin
  if T=Type::Arithmetical or T=Type::Set then
    TRUE
  else
    FAIL
  end_if
end_proc:

undef::iszero:= () -> FALSE:

undef::has:= proc(x, T) begin
    if T = undefined then
	TRUE
    elif domtype(T) = stdlib::Undefined then
	has(expr(x), expr(T))
    elif x = undefined then
      FALSE
    else
	has(extop(x,1), T)
    end_if
end_proc:

// undefined is defined nowhere; hence discont(undefined, .., F) must give F

undef::discont:=
proc(f, x, F)

begin
  if type(x) = "_equal" then
    Dom::Interval([op(op(x, 2))])
  elif args(0)=3 and F = Dom::Real then
    R_
  else
    C_
  end_if
end_proc:


// define some methods to avoid creation via make_slot 
undef::evaluate:= FAIL:
undef::posteval:= FAIL:
undef::undefinedEntries := FAIL:
undef::allEntries := FAIL:
undef::allAutoEntries := FAIL:
undef::whichEntry := FAIL:
undef::new_extelement := FAIL:
undef::create_dom_elem := FAIL:
undef::Content:=FAIL:
undef::MMLContent := FAIL:
undef::Name := "stdlib::Undefined":
undef::eval := FAIL:
undef::domtype:= FAIL:
undef::type:= FAIL:
undef::isNeg:= FAIL:
undef::isInverted:= FAIL:
undef::slot:= FAIL:
undef::expr2text:= FAIL: 
undef::indets:= FAIL:
undef::freeIndets:= FAIL:
undef::bool :=FAIL:
undef::length := 1:
undef::rectform:= FAIL:
undef::contains:= (x,y) -> if x=y then TRUE else FALSE end_if:
undef::expose := FAIL:
undef::hastype := FAIL:
undef::maprec := FAIL:
undef::operandsToSimplify:= FAIL:
undef::Simplify := FAIL;
undef::simplify := FAIL;
undef::testeq:= FAIL:
undef::evaluateIndex := FAIL:
undef::sortSums := FAIL:
undef::CF:= loadproc(stdlib::Undefined::CF, pathname("GENERATE"),"CF"):

undef::op := undefined:
undef::nops := 1:
undef::subsop := proc() begin
  if lhs(args(2)) = 1 then
    rhs(args(2))
  else
    FAIL
  end_if
end_proc:

/*--
make_slot -- create default method

make_slot allways returns a function returning 'undefined'.

NOTE: This MUST be the last method defined for undefined.
--*/

undef::make_slot:= undef::func_call;

sysassign(stdlib::Undefined, undef);

null();

end_proc():
