//      
// kg, 11.05.93 

/*++
use -- export interface names of a library domain into global name space

use(lib, [ name_1,...,name_n ] )

lib               - library domain
name_1,...,name_2 - names to be used

use is a convenience function to export function names of library domains.
If 'lib' is a library domain and 'lib::func' is a function of that library,
the function may be called via 'lib::func(...)'.

Often one wishes simply to call 'func(...)'. If the name 'func' is contained
in the set 'lib::interface' of library interface names, it may be exported
into the global name space via 'use(lib,func);'. After the name is exported,
one may call 'func(...)' directly.

More than one name may be exported at a time. If no name is given, all the
names in the set 'lib::interface' are exported.

If a name to be exported already has a value, the value is not redefined and
a warning is printed.
++*/

use:=
  proc(dm)
    local names, useAliases, __name__, exportName;
    option hold;
  begin
    if args(0) < 1 then
       error("expecting at least 1 argument");
    end_if:
    dm:= context(dm);
    if args(0) < 1 then error("wrong number of arguments") end_if;
    if domtype(dm) <> DOM_DOMAIN then error("argument '".prog::getname(dm)."' is not a domain") end_if;
    if domtype(dm::interface) <> DOM_SET then
        error("given domain '".prog::getname(dm)."' has no interface") 
    end_if;
    if dm::_exported = FAIL then dm::_exported:= {} end_if;

    // Look for an Alias option
    names := [args(2..args(0))];
    if contains(names, Alias) > 0 then
	names := select(names, not _equal, Alias);
	useAliases := TRUE;
    else
	useAliases := FALSE;
    end_if;

    exportName :=
    proc(__name__) // Note: don't use `name' which is a reserved keyword)
	local str, holder, entry, parserConfig;
    begin
	str:= "".__name__;
	// Do some sanity checks (already exported names and so on)
	if useAliases then
	    // Ok, go on
	elif eval(subsop(hold(val(NIL)),1=__name__)) = __name__ then
	    // Ok, go on
	elif contains(dm::_exported, __name__) then
//	    print(NoNL,
//		  "Info: '".expr2text(dm)."::".str."' already is exported.\n");
	    return();
	elif prog::findChanges(hold(Quiet), __name__) <> FAIL then
	    // Ok, go on
	else
	    context(hold(warning)("'".str."' already has a value, not exported."));
	    return();
	end_if;
	// Do the export
	if useAliases then
	    parserConfig := _parser_config();
	    if parserConfig = null() then
		parserConfig := [ table(), table(), table(), [] ];
	    end_if;
	    entry := slot(dm, str);
	  if contains(parserConfig[2], entry) and
	     parserConfig[2][entry] <> __name__ then
	    context(hold(warning)("'".prog::getname(entry)."' already has an alias; not exported."));
	    return();
	  elif contains(parserConfig[1], __name__) and
	       parserConfig[1][__name__] <> entry then
	    context(hold(warning)("'".str."' already is an alias; not exported."));
	    return();
	  end_if;
	  parserConfig[1][__name__]   := entry;
	  parserConfig[2][entry] := __name__;
	  _parser_config(parserConfig);
	else
	    holder := hold(new(stdlib::EvalExported, __name__, dm, str));
	    if traperror(eval(subsop(hold((i:=i)), 1=__name__, 2=%))) = 0 then
               dm::_exported:= dm::_exported union { __name__ };
               protected( __name__, Error);
            else
   	       context(hold(warning)("'".str."' seems to be proteced; not exported."));
            end_if:
	end_if;
    end_proc;
      
    if nops(names) = 0 then
        for __name__ in dm::interface do
	    if domtype(__name__) <> DOM_IDENT then
		error("in interface: name must be an identifier")
	    end_if;
	    exportName(__name__);
	end_for
    else
	for __name__ in names do
	    if domtype(__name__) <> DOM_IDENT then
		error("global name '".prog::getname(__name__)."' must be an identifier")
	    end_if;
	    if not contains(dm::interface, __name__) then
	    	error("interface of '".prog::getname(dm)."' does not contain method '".expr2text(__name__)."'")
	    end_if;
	    exportName(__name__);
	end_for
    end_if;
    null()
end_proc:

/*
stdlib::EvalExported -- domain to evaluate exported name to domain entry

An element of this domain is assigned to each exported name. When the
domain element is evaluated it assigns the domain entry which contains the
value to be exported to the exported name.

We can't assign the domain entry to be exported to the name directly 
because that would cause the loading of those entries from file which
are defined via 'loadproc'.

An element has operands
1- name of exported function
2- domain from which to export function
3- index of domain entry
*/

alias( D1=stdlib::EvalExported ):

D1:=  newDomain("stdlib::EvalExported"):
D1::create_dom:=hold(use):

D1::new:= proc() begin
    new(D1, args())
end_proc:

D1::evaluate:= proc()
begin
    eval(subsop(hold(sysassign(NIL,NIL)),
	    1=extop(args(1),1),
	    2=slot(extop(args(1),2), extop(args(1),3))));
    context(extop(args(1),1))
end_proc:

D1::posteval:= D1::evaluate:

D1::func_call:=
proc()
  local i;
begin
    eval(subsop(hold(sysassign(NIL,NIL)),
	    1=extop(args(1),1),
	    2=slot(extop(args(1),2), extop(args(1),3))));
    context(extop(args(1),1)(args(i) $ i=2..args(0)))
end_proc:

D1::set_func_call:=
proc()
  local i;
begin
    eval(subsop(hold(sysassign(NIL,NIL)),
	    1=extop(args(1),1),
	    2=slot(extop(args(1),2), extop(args(1),3))));
    eval(subsop(hold(sysassign(NIL(NIL),NIL)),
	    [1,0]=extop(args(1),1),
	    [1,1]=(args(i) $ i=2..args(0)-1), 2=args(args(0))));
    context(extop(args(1),1))
end_proc:

unalias( D1 ):

// end of file 
