/*- $Id

stringlib::formatTime - print time measures in a readable way

>> stringlib::formatTime(1200)

   "1.2 seconds"

>> stringlib::formatTime(0.5*unit::h)

   "30 minutes"
   
>> stringlib::formatTime(7406400)

   "2 hours, 3.44 minutes"
   
>> stringlib::formatTime(7406400, 3)

   "2 hours, 3 minutes, 26.4 seconds"

-*/

stringlib::formatTime :=
proc(msec, ops=2)
  local res, unt, t, isNeg;
begin
  if args(0) < 1 or args(0) > 2 then
    error("wrong number of arguments");
  end_if;
  msec := float(msec);
  if domtype(msec) <> DOM_FLOAT then
    msec := unit::convert(msec, unit::sec)*1000.0/unit::sec;
  end;
  if domtype(msec) <> DOM_FLOAT then
    error("bad time specification")
  end_if;
  if msec < 0 then
    isNeg:= TRUE;
    msec:= abs(msec);
  else
    isNeg:= FALSE;
  end_if;
  if not testtype(ops, Type::PosInt) then
    error("bad format specification (positive integer expected)")
  end;
  res := "";
  for unt in [[31536000000, "year"],
              [2592000000, "month"], // consistent with unit::month
              [604800000, "week"],
              [86400000, "day"],
              [3600000, "hour"],
              [60000, "minute"]] do
    if msec >= unt[1] then
      ops := ops - 1;
      if iszero(ops) then
        if iszero(msec-unt[1]) then
          res := res . ", 1 " . unt[2];
        else
          t := expr2text(msec/unt[1]);
          // at most two digits after the decimal point
          t := strmatch(t, "^(\\d*(\\.\\d{0,2})?).*?(e\\d+)?$", ReturnMatches);
          t := t[2].t[4];
          res := res . ", " . t . " " . unt[2] . "s"
        end;
        msec := 0;
        break;
      else
        if iszero(msec-unt[1]) then
          res := res . ", 1 " . unt[2];
          msec:= 0;
        else
          t := floor(msec/unt[1]);
          res := res . ", " . t . " " . unt[2] . (if t > 1 then "s" else "" end);
          msec := msec - t * unt[1];
        end;
      end;
    end;
  end;
  if ops > 0 and msec > 0 then
    if iszero(msec-1000) then
      res := res . ", 1 second";
    else
      t := expr2text(msec/1000);
      res := res . ", " . t . " seconds";
    end;
  end;
  if res = "" then
    res := "0 seconds";
  else
    if isNeg then
      res := "-".res[3..-1];
    else
      res := res[3..-1];
    end;
  end;
end:


