// 

// bij
// returns a procedure that compares two strings
// usable as second argument of sort
// options
//          Lexicographical - default
//          Reverse
//          Nocase
//          ReverseNocase

stringlib::order:=
  proc(OPT = hold(Lexicographical))
    option escape;
  begin
    if args(0) > 1 then
      error("wrong number of arguments");
    end_if;
    if domtype(OPT) <> DOM_IDENT then
      error("illegal argument");
    end_if;
    if not contains({hold(Lexicographical),hold(Reverse),hold(Nocase),hold(ReverseNocase)},OPT) then
      error("illegal option");
    end_if;
    
    proc(STR1, STR2)
    begin
      bool((case OPT
              of hold(Lexicographical) do
                op(sort([STR1, STR2]), 1) = STR1;
                break
              of hold(Reverse) do
                // change variables
                op(sort([STR1, STR2]), 2) = STR1;
                break
              of hold(Nocase) do
                // change variables
                STR1:= stringlib::lower(STR1);
                STR2:= stringlib::lower(STR2);
                op(sort([STR1, STR2]), 1) = STR1;
                break
              of hold(ReverseNocase) do
                // change variables
                STR1:= stringlib::lower(STR1);
                STR2:= stringlib::lower(STR2);
                op(sort([STR1, STR2]), 2) = STR1;
                break
              otherwise
                TRUE
            end_case))
    end_proc
  end_proc: