stringlib::pos := proc(s, t, r)
   local a, b, m, n, pos;
begin
  if args(0) < 2 or args(0) > 3 then
    error("wrong number of arguments");
  end_if;
  if domtype(s) <> DOM_STRING or s = "" or domtype(t) <> DOM_STRING or t = "" then
     error("non-empty string expected");
  end_if;
  m := length(s); 
  n := length(t);
  if args(0) = 2 then
     a := stringlib::FirstIndex;
  elif type(r) = "_range" then
     a := op(r, 1); 
     b := op(r, 2);
     if domtype(a) <> DOM_INT or domtype(b) <> DOM_INT or a < 1 or a > b or b > m then
        error("illegal range");
     end_if;
     m := b;
  else
    if domtype(r) <> DOM_INT or r < 1 or r > m then
      error("illegal index");
    end_if;
    a := r;
  end_if;
  
  pos := op(strmatch(s[a..m], stringlib::maskMeta(t), Index), 1);
  if pos = FALSE then
    FAIL
  else
    pos + a - 1;
  end_if;
end_proc:
