/*-

stringlib::remove -- deletes substrings

Calling sequence:

stringlib::remove(s, t)
stringlib::remove(s, t, First)
stringlib::remove(s, a)
stringlib::remove(s, a..b)

Parameter:

s, t  - strings
a, b  - non-negative integers
First - name

Examples:

>> stringlib::remove("abcdab", "ab", First);

                                  "cdab"

>> stringlib::remove("abcdab", "ab");       

                                   "cd"

>> stringlib::remove("abcdab", 3);

                                  "abcab"

>> stringlib::remove("abcdab", 1..3);
 
                                   "aab"
-*/

stringlib::remove :=
proc(s : DOM_STRING, r, opt = null())
   local a, b, len;
begin

  if testargs() then
    if args(0) < 2 or args(0) > 3 then
      error("wrong number of arguments");
    end_if;
    
    len := length(s);
    if type(r) = "_range" then
      a := op(r, 1);
      b := op(r, 2);
      if domtype(a) <> DOM_INT or domtype(b) <> DOM_INT or a < 1 or a > b or b > len then
        error("illegal range")
      end_if;
       
    elif domtype(r) = DOM_INT then
      if (r < 1 or r > len) then
        error("illegal index")
      end_if;
      
    elif domtype(r) = DOM_STRING then
      if args(0) = 3 then
        if opt <> First then
          error("illegal option")
        end_if;
      end_if;
          
    else
      error("illegal argument")
    end_if
  end_if;

  if domtype(r) = DOM_STRING then
    stringlib::subs(s, r="", opt)
  else
    stringlib::subsop(s, r="")
  end_if

end_proc:
